/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import org.hipparchus.exception.Localizable;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.OnOff;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitManeuver;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.time.DateTimeComponents;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.units.Unit;

public enum ManeuverFieldType {
    TIME_ABSOLUTE("n/a", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDate(context.getTimeSystem().getConverter(context).parse(field)), (u, converter, maneuver) -> {
        DateTimeComponents dt = converter.components(maneuver.getDate());
        return AccurateFormatter.format(dt.getDate().getYear(), dt.getDate().getMonth(), dt.getDate().getDay(), dt.getTime().getHour(), dt.getTime().getMinute(), dt.getTime().getSecond());
    }),
    TIME_RELATIVE("s", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDate(context.getReferenceDate().shiftedBy(ManeuverFieldType.toSI(field, u))), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(converter.offset(maneuver.getDate())))),
    MAN_DURA("s", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDuration(ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getDuration()))),
    DELTA_MASS("kg", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDeltaMass(ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getDeltaMass()))),
    ACC_X("km/s\u00b2", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setAcceleration(0, ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getAcceleration().getX()))),
    ACC_Y("km/s\u00b2", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setAcceleration(1, ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getAcceleration().getY()))),
    ACC_Z("km/s\u00b2", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setAcceleration(2, ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getAcceleration().getZ()))),
    ACC_INTERP("n/a", (field, u, context, maneuver, lineNumber, fileName) -> {
        try {
            maneuver.setAccelerationInterpolation(OnOff.valueOf(field));
        }
        catch (IllegalArgumentException iae) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, lineNumber, fileName, field);
        }
    }, (u, converter, maneuver) -> maneuver.getAccelerationInterpolation().name()),
    ACC_MAG_SIGMA("%", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setAccelerationMagnitudeSigma(ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getAccelerationMagnitudeSigma()))),
    ACC_DIR_SIGMA("\u00b0", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setAccelerationDirectionSigma(ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getAccelerationDirectionSigma()))),
    DV_X("km/s", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDv(0, ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getDv().getX()))),
    DV_Y("km/s", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDv(1, ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getDv().getY()))),
    DV_Z("km/s", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDv(2, ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getDv().getZ()))),
    DV_MAG_SIGMA("%", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDvMagSigma(ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getDvMagSigma()))),
    DV_DIR_SIGMA("\u00b0", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDvDirSigma(ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getDvDirSigma()))),
    THR_X("N", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setThrust(0, ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getThrust().getX()))),
    THR_Y("N", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setThrust(1, ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getThrust().getY()))),
    THR_Z("N", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setThrust(2, ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getThrust().getZ()))),
    THR_EFFIC("n/a", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setThrustEfficiency(ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getThrustEfficiency()))),
    THR_INTERP("n/a", (field, u, context, maneuver, lineNumber, fileName) -> {
        try {
            maneuver.setThrustInterpolation(OnOff.valueOf(field));
        }
        catch (IllegalArgumentException iae) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, lineNumber, fileName, field);
        }
    }, (u, converter, maneuver) -> maneuver.getThrustInterpolation().name()),
    THR_ISP("s", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setThrustIsp(ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getThrustIsp()))),
    THR_MAG_SIGMA("%", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setThrustMagnitudeSigma(ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getThrustMagnitudeSigma()))),
    THR_DIR_SIGMA("\u00b0", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setThrustDirectionSigma(ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getThrustDirectionSigma()))),
    DEPLOY_ID("n/a", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDeployId(field), (u, converter, maneuver) -> maneuver.getDeployId()),
    DEPLOY_DV_X("km/s", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDeployDv(0, ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getDeployDv().getX()))),
    DEPLOY_DV_Y("km/s", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDeployDv(1, ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getDeployDv().getY()))),
    DEPLOY_DV_Z("km/s", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDeployDv(2, ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getDeployDv().getZ()))),
    DEPLOY_MASS("kg", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDeployMass(ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getDeployMass()))),
    DEPLOY_DV_SIGMA("%", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDeployDvSigma(ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getDeployDvSigma()))),
    DEPLOY_DIR_SIGMA("\u00b0", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDeployDirSigma(ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getDeployDirSigma()))),
    DEPLOY_DV_RATIO("n/a", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDeployDvRatio(ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getDeployDvRatio()))),
    DEPLOY_DV_CDA("m\u00b2", (field, u, context, maneuver, lineNumber, fileName) -> maneuver.setDeployDvCda(ManeuverFieldType.toSI(field, u)), (u, converter, maneuver) -> AccurateFormatter.format(u.fromSI(maneuver.getDeployDvCda())));

    private final Unit unit;
    private final transient FieldProcessor processor;
    private final transient FieldWriter writer;

    private ManeuverFieldType(String unitSpecifications, FieldProcessor processor, FieldWriter writer) {
        this.unit = Unit.parse(unitSpecifications);
        this.processor = processor;
        this.writer = writer;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void checkUnit(Unit parsedUnit) {
        if (this.unit == Unit.NONE ^ parsedUnit == Unit.NONE || !this.unit.sameDimension(parsedUnit) || !Precision.equals((double)this.unit.getScale(), (double)parsedUnit.getScale(), (int)1)) {
            throw new OrekitException((Localizable)OrekitMessages.INCOMPATIBLE_UNITS, this.unit.getName(), parsedUnit.getName());
        }
    }

    public boolean isTime() {
        return this == TIME_ABSOLUTE || this == TIME_RELATIVE;
    }

    private static double toSI(String field, Unit unit) {
        return unit.toSI(Double.parseDouble(field));
    }

    public void process(String field, ContextBinding context, OrbitManeuver maneuver, int lineNumber, String fileName) {
        this.processor.process(field, this.unit, context, maneuver, lineNumber, fileName);
    }

    public String outputField(TimeConverter converter, OrbitManeuver maneuver) {
        return this.writer.output(this.unit, converter, maneuver);
    }

    static interface FieldWriter {
        public String output(Unit var1, TimeConverter var2, OrbitManeuver var3);
    }

    static interface FieldProcessor {
        public void process(String var1, Unit var2, ContextBinding var3, OrbitManeuver var4, int var5, String var6);
    }
}

