/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.odm.OdmHeader;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmMetadataWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitElementsType;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryState;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistoryMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistoryWriter;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.AbstractGenerator;
import org.orekit.files.ccsds.utils.generation.KvnGenerator;
import org.orekit.files.ccsds.utils.generation.XmlGenerator;
import org.orekit.files.general.EphemerisFile;
import org.orekit.files.general.EphemerisFileWriter;
import org.orekit.frames.Frame;
import org.orekit.utils.TimeStampedPVCoordinates;

public class EphemerisOcmWriter
implements EphemerisFileWriter {
    private final OcmWriter writer;
    private final OdmHeader header;
    private final OcmMetadata metadata;
    private final TrajectoryStateHistoryMetadata trajectoryMetadata;
    private final FileFormat fileFormat;
    private final String outputName;
    private final int unitsColumn;
    private final double maxRelativeOffset;
    private final OneAxisEllipsoid body;

    public EphemerisOcmWriter(OcmWriter writer, OdmHeader header, OcmMetadata metadata, TrajectoryStateHistoryMetadata template, FileFormat fileFormat, String outputName, double maxRelativeOffset, int unitsColumn) {
        this.writer = writer;
        this.header = header;
        this.metadata = metadata.copy(header == null ? writer.getDefaultVersion() : header.getFormatVersion());
        this.trajectoryMetadata = template.copy(header == null ? writer.getDefaultVersion() : header.getFormatVersion());
        this.fileFormat = fileFormat;
        this.outputName = outputName;
        this.maxRelativeOffset = maxRelativeOffset;
        this.unitsColumn = unitsColumn;
        this.body = Double.isNaN(writer.getEquatorialRadius()) ? null : new OneAxisEllipsoid(writer.getEquatorialRadius(), writer.getFlattening(), template.getTrajReferenceFrame().asFrame());
    }

    @Override
    public <C extends TimeStampedPVCoordinates, S extends EphemerisFile.EphemerisSegment<C>> void write(Appendable appendable, EphemerisFile<C, S> ephemerisFile) throws IOException {
        if (appendable == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NULL_ARGUMENT, "writer");
        }
        if (ephemerisFile == null) {
            return;
        }
        String name = this.metadata.getObjectName() != null ? this.metadata.getObjectName() : (this.metadata.getInternationalDesignator() != null ? this.metadata.getInternationalDesignator() : (this.metadata.getObjectDesignator() != null ? this.metadata.getObjectDesignator() : "UNKNOWN"));
        EphemerisFile.SatelliteEphemeris<C, S> satEphem = ephemerisFile.getSatellites().get(name);
        if (satEphem == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.VALUE_NOT_FOUND, name, "ephemerisFile");
        }
        List<S> blocks = satEphem.getSegments();
        if (blocks.isEmpty()) {
            return;
        }
        try (AbstractGenerator generator = this.fileFormat == FileFormat.KVN ? new KvnGenerator(appendable, 24, this.outputName, this.maxRelativeOffset, this.unitsColumn) : new XmlGenerator(appendable, 2, this.outputName, this.maxRelativeOffset, this.unitsColumn > 0, null);){
            this.writer.writeHeader(generator, this.header);
            if (generator.getFormat() == FileFormat.XML) {
                generator.enterSection(XmlStructureKey.segment.name());
            }
            this.metadata.setStartTime(((EphemerisFile.EphemerisSegment)blocks.get(0)).getStart());
            this.metadata.setStopTime(((EphemerisFile.EphemerisSegment)blocks.get(blocks.size() - 1)).getStop());
            new OcmMetadataWriter(this.metadata, this.writer.getTimeConverter()).write(generator);
            if (generator.getFormat() == FileFormat.XML) {
                generator.enterSection(XmlStructureKey.data.name());
            }
            double lastZ = Double.NaN;
            for (EphemerisFile.EphemerisSegment block : blocks) {
                this.trajectoryMetadata.setTrajNextID(TrajectoryStateHistoryMetadata.incrementTrajID(this.trajectoryMetadata.getTrajID()));
                this.trajectoryMetadata.setUseableStartTime(block.getStart());
                this.trajectoryMetadata.setUseableStopTime(block.getStop());
                this.trajectoryMetadata.setInterpolationDegree(block.getInterpolationSamples() - 1);
                OrbitElementsType type = this.trajectoryMetadata.getTrajType();
                Frame frame = this.trajectoryMetadata.getTrajReferenceFrame().asFrame();
                int crossings = 0;
                ArrayList<TrajectoryState> states = new ArrayList<TrajectoryState>(block.getCoordinates().size());
                for (TimeStampedPVCoordinates pv : block.getCoordinates()) {
                    if (lastZ < 0.0 && pv.getPosition().getZ() >= 0.0) {
                        ++crossings;
                    }
                    lastZ = pv.getPosition().getZ();
                    states.add(new TrajectoryState(type, pv.getDate(), type.toRawElements(pv, frame, this.body, block.getMu())));
                }
                TrajectoryStateHistory history = new TrajectoryStateHistory(this.trajectoryMetadata, states, this.body, block.getMu());
                TrajectoryStateHistoryWriter trajectoryWriter = new TrajectoryStateHistoryWriter(history, this.writer.getTimeConverter());
                trajectoryWriter.write(generator);
                this.trajectoryMetadata.setTrajPrevID(this.trajectoryMetadata.getTrajID());
                this.trajectoryMetadata.setTrajID(this.trajectoryMetadata.getTrajNextID());
                if (this.trajectoryMetadata.getOrbRevNum() < 0) continue;
                this.trajectoryMetadata.setOrbRevNum(this.trajectoryMetadata.getOrbRevNum() + crossings);
            }
            if (generator.getFormat() == FileFormat.XML) {
                generator.exitSection();
                generator.exitSection();
            }
            this.writer.writeFooter(generator);
        }
    }
}

