/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm;

import org.orekit.files.ccsds.ndm.odm.KeplerianElementsKey;
import org.orekit.files.ccsds.ndm.odm.StateVectorKey;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.files.ccsds.section.Data;
import org.orekit.frames.Frame;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.PositionAngleType;
import org.orekit.time.AbsoluteDate;

public class KeplerianElements
extends CommentsContainer
implements Data {
    private AbsoluteDate epoch;
    private double a = Double.NaN;
    private double meanMotion = Double.NaN;
    private double e = Double.NaN;
    private double i = Double.NaN;
    private double raan = Double.NaN;
    private double pa = Double.NaN;
    private double anomaly = Double.NaN;
    private PositionAngleType anomalyType;
    private double mu = Double.NaN;

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkNotNull(this.epoch, StateVectorKey.EPOCH.name());
        this.checkNotNaN(this.e, KeplerianElementsKey.ECCENTRICITY.name());
        this.checkNotNaN(this.i, KeplerianElementsKey.INCLINATION.name());
        this.checkNotNaN(this.raan, KeplerianElementsKey.RA_OF_ASC_NODE.name());
        this.checkNotNaN(this.pa, KeplerianElementsKey.ARG_OF_PERICENTER.name());
        this.checkNotNaN(this.anomaly, KeplerianElementsKey.MEAN_ANOMALY.name());
    }

    public AbsoluteDate getEpoch() {
        return this.epoch;
    }

    public void setEpoch(AbsoluteDate epoch) {
        this.refuseFurtherComments();
        this.epoch = epoch;
    }

    public double getA() {
        return this.a;
    }

    public void setA(double a) {
        this.refuseFurtherComments();
        this.a = a;
    }

    public double getMeanMotion() {
        return this.meanMotion;
    }

    public void setMeanMotion(double motion) {
        this.meanMotion = motion;
    }

    public double getE() {
        return this.e;
    }

    public void setE(double e) {
        this.refuseFurtherComments();
        this.e = e;
    }

    public double getI() {
        return this.i;
    }

    public void setI(double i) {
        this.refuseFurtherComments();
        this.i = i;
    }

    public double getRaan() {
        return this.raan;
    }

    public void setRaan(double raan) {
        this.refuseFurtherComments();
        this.raan = raan;
    }

    public double getPa() {
        return this.pa;
    }

    public void setPa(double pa) {
        this.refuseFurtherComments();
        this.pa = pa;
    }

    public double getAnomaly() {
        return this.anomaly;
    }

    public void setAnomaly(double anomaly) {
        this.refuseFurtherComments();
        this.anomaly = anomaly;
    }

    public PositionAngleType getAnomalyType() {
        return this.anomalyType;
    }

    public void setAnomalyType(PositionAngleType anomalyType) {
        this.refuseFurtherComments();
        this.anomalyType = anomalyType;
    }

    public void setMu(double mu) {
        this.refuseFurtherComments();
        this.mu = mu;
    }

    public double getMu() {
        return this.mu;
    }

    public KeplerianOrbit generateKeplerianOrbit(Frame frame) {
        return new KeplerianOrbit(this.a, this.e, this.i, this.pa, this.raan, this.anomaly, this.anomalyType, frame, this.epoch, this.mu);
    }
}

