/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.odm.CommonMetadataKey;
import org.orekit.files.ccsds.ndm.odm.OdmCommonMetadata;
import org.orekit.files.ccsds.ndm.odm.OdmMetadataKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.generation.Generator;

public class CommonMetadataWriter
extends AbstractWriter {
    private final OdmCommonMetadata metadata;
    private final TimeConverter timeConverter;

    public CommonMetadataWriter(OdmCommonMetadata metadata, TimeConverter timeConverter) {
        super(XmlStructureKey.metadata.name(), null);
        this.metadata = metadata;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.metadata.getComments());
        generator.writeEntry(OdmMetadataKey.OBJECT_NAME.name(), this.metadata.getObjectName(), null, true);
        generator.writeEntry(CommonMetadataKey.OBJECT_ID.name(), this.metadata.getObjectID(), null, true);
        generator.writeEntry(CommonMetadataKey.CENTER_NAME.name(), this.metadata.getCenter().getName(), null, true);
        generator.writeEntry(CommonMetadataKey.REF_FRAME.name(), this.metadata.getReferenceFrame().getName(), null, true);
        generator.writeEntry(CommonMetadataKey.REF_FRAME_EPOCH.name(), this.timeConverter, this.metadata.getFrameEpoch(), true, false);
        generator.writeEntry(MetadataKey.TIME_SYSTEM.name(), this.metadata.getTimeSystem(), true);
    }
}

