/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.cdm.CdmMetadataKey;
import org.orekit.files.ccsds.ndm.cdm.XYZCovarianceKey;
import org.orekit.files.ccsds.section.CommentsContainer;

public class XYZCovariance
extends CommentsContainer {
    private RealMatrix covarianceMatrix;
    private boolean covXYZset;

    public XYZCovariance(boolean covXYZset) {
        this.covXYZset = covXYZset;
        this.covarianceMatrix = MatrixUtils.createRealMatrix((int)9, (int)9);
        for (int i = 0; i < this.covarianceMatrix.getRowDimension(); ++i) {
            for (int j = 0; j <= i; ++j) {
                this.covarianceMatrix.setEntry(i, j, Double.NaN);
            }
        }
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        if (!this.isCovXYZset()) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, new Object[]{CdmMetadataKey.ALT_COV_TYPE});
        }
        this.checkNotNaN(this.getCxx(), XYZCovarianceKey.CX_X.name());
        this.checkNotNaN(this.getCyx(), XYZCovarianceKey.CY_X.name());
        this.checkNotNaN(this.getCyy(), XYZCovarianceKey.CY_Y.name());
        this.checkNotNaN(this.getCzx(), XYZCovarianceKey.CZ_X.name());
        this.checkNotNaN(this.getCzy(), XYZCovarianceKey.CZ_Y.name());
        this.checkNotNaN(this.getCzz(), XYZCovarianceKey.CZ_Z.name());
        this.checkNotNaN(this.getCxdotx(), XYZCovarianceKey.CXDOT_X.name());
        this.checkNotNaN(this.getCxdoty(), XYZCovarianceKey.CXDOT_Y.name());
        this.checkNotNaN(this.getCxdotz(), XYZCovarianceKey.CXDOT_Z.name());
        this.checkNotNaN(this.getCxdotxdot(), XYZCovarianceKey.CXDOT_XDOT.name());
        this.checkNotNaN(this.getCydotx(), XYZCovarianceKey.CYDOT_X.name());
        this.checkNotNaN(this.getCydoty(), XYZCovarianceKey.CYDOT_Y.name());
        this.checkNotNaN(this.getCydotz(), XYZCovarianceKey.CYDOT_Z.name());
        this.checkNotNaN(this.getCydotxdot(), XYZCovarianceKey.CYDOT_XDOT.name());
        this.checkNotNaN(this.getCydotydot(), XYZCovarianceKey.CYDOT_YDOT.name());
        this.checkNotNaN(this.getCzdotx(), XYZCovarianceKey.CZDOT_X.name());
        this.checkNotNaN(this.getCzdoty(), XYZCovarianceKey.CZDOT_Y.name());
        this.checkNotNaN(this.getCzdotz(), XYZCovarianceKey.CZDOT_Z.name());
        this.checkNotNaN(this.getCzdotxdot(), XYZCovarianceKey.CZDOT_XDOT.name());
        this.checkNotNaN(this.getCzdotydot(), XYZCovarianceKey.CZDOT_YDOT.name());
        this.checkNotNaN(this.getCzdotzdot(), XYZCovarianceKey.CZDOT_ZDOT.name());
    }

    public void setCovarianceMatrixEntry(int j, int k, double entry) {
        this.covarianceMatrix.setEntry(j, k, entry);
        this.covarianceMatrix.setEntry(k, j, entry);
    }

    public RealMatrix getXYZCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public double getCxx() {
        return this.covarianceMatrix.getEntry(0, 0);
    }

    public void setCxx(double CXX) {
        this.refuseFurtherComments();
        if (!this.isCovXYZset()) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, new Object[]{CdmMetadataKey.ALT_COV_TYPE});
        }
        this.setCovarianceMatrixEntry(0, 0, CXX);
    }

    public double getCyx() {
        return this.covarianceMatrix.getEntry(1, 0);
    }

    public void setCyx(double CYX) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(1, 0, CYX);
    }

    public double getCyy() {
        return this.covarianceMatrix.getEntry(1, 1);
    }

    public void setCyy(double CYY) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(1, 1, CYY);
    }

    public double getCzx() {
        return this.covarianceMatrix.getEntry(2, 0);
    }

    public void setCzx(double CZX) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(2, 0, CZX);
    }

    public double getCzy() {
        return this.covarianceMatrix.getEntry(2, 1);
    }

    public void setCzy(double CZY) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(2, 1, CZY);
    }

    public double getCzz() {
        return this.covarianceMatrix.getEntry(2, 2);
    }

    public void setCzz(double CZZ) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(2, 2, CZZ);
    }

    public double getCxdotx() {
        return this.covarianceMatrix.getEntry(3, 0);
    }

    public void setCxdotx(double CXdotX) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(3, 0, CXdotX);
    }

    public double getCxdoty() {
        return this.covarianceMatrix.getEntry(3, 1);
    }

    public void setCxdoty(double CXdotY) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(3, 1, CXdotY);
    }

    public double getCxdotz() {
        return this.covarianceMatrix.getEntry(3, 2);
    }

    public void setCxdotz(double CXdotZ) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(3, 2, CXdotZ);
    }

    public double getCxdotxdot() {
        return this.covarianceMatrix.getEntry(3, 3);
    }

    public void setCxdotxdot(double CXdotXdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(3, 3, CXdotXdot);
    }

    public double getCydotx() {
        return this.covarianceMatrix.getEntry(4, 0);
    }

    public void setCydotx(double CYdotX) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(4, 0, CYdotX);
    }

    public double getCydoty() {
        return this.covarianceMatrix.getEntry(4, 1);
    }

    public void setCydoty(double CYdotY) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(4, 1, CYdotY);
    }

    public double getCydotz() {
        return this.covarianceMatrix.getEntry(4, 2);
    }

    public void setCydotz(double CYdotZ) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(4, 2, CYdotZ);
    }

    public double getCydotxdot() {
        return this.covarianceMatrix.getEntry(4, 3);
    }

    public void setCydotxdot(double CYdotXdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(4, 3, CYdotXdot);
    }

    public double getCydotydot() {
        return this.covarianceMatrix.getEntry(4, 4);
    }

    public void setCydotydot(double CYdotYdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(4, 4, CYdotYdot);
    }

    public double getCzdotx() {
        return this.covarianceMatrix.getEntry(5, 0);
    }

    public void setCzdotx(double CZdotX) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(5, 0, CZdotX);
    }

    public double getCzdoty() {
        return this.covarianceMatrix.getEntry(5, 1);
    }

    public void setCzdoty(double CZdotY) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(5, 1, CZdotY);
    }

    public double getCzdotz() {
        return this.covarianceMatrix.getEntry(5, 2);
    }

    public void setCzdotz(double CZdotZ) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(5, 2, CZdotZ);
    }

    public double getCzdotxdot() {
        return this.covarianceMatrix.getEntry(5, 3);
    }

    public void setCzdotxdot(double CZdotXdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(5, 3, CZdotXdot);
    }

    public double getCzdotydot() {
        return this.covarianceMatrix.getEntry(5, 4);
    }

    public void setCzdotydot(double CZdotYdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(5, 4, CZdotYdot);
    }

    public double getCzdotzdot() {
        return this.covarianceMatrix.getEntry(5, 5);
    }

    public void setCzdotzdot(double CZdotZdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(5, 5, CZdotZdot);
    }

    public double getCdrgx() {
        return this.covarianceMatrix.getEntry(6, 0);
    }

    public void setCdrgx(double CDRGX) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(6, 0, CDRGX);
    }

    public double getCdrgy() {
        return this.covarianceMatrix.getEntry(6, 1);
    }

    public void setCdrgy(double CDRGY) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(6, 1, CDRGY);
    }

    public double getCdrgz() {
        return this.covarianceMatrix.getEntry(6, 2);
    }

    public void setCdrgz(double CDRGZ) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(6, 2, CDRGZ);
    }

    public double getCdrgxdot() {
        return this.covarianceMatrix.getEntry(6, 3);
    }

    public void setCdrgxdot(double CDRGXdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(6, 3, CDRGXdot);
    }

    public double getCdrgydot() {
        return this.covarianceMatrix.getEntry(6, 4);
    }

    public void setCdrgydot(double CDRGYdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(6, 4, CDRGYdot);
    }

    public double getCdrgzdot() {
        return this.covarianceMatrix.getEntry(6, 5);
    }

    public void setCdrgzdot(double CDRGZdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(6, 5, CDRGZdot);
    }

    public double getCdrgdrg() {
        return this.covarianceMatrix.getEntry(6, 6);
    }

    public void setCdrgdrg(double CDRGDRG) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(6, 6, CDRGDRG);
    }

    public double getCsrpx() {
        return this.covarianceMatrix.getEntry(7, 0);
    }

    public void setCsrpx(double CSRPX) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(7, 0, CSRPX);
    }

    public double getCsrpy() {
        return this.covarianceMatrix.getEntry(7, 1);
    }

    public void setCsrpy(double CSRPY) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(7, 1, CSRPY);
    }

    public double getCsrpz() {
        return this.covarianceMatrix.getEntry(7, 2);
    }

    public void setCsrpz(double CSRPZ) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(7, 2, CSRPZ);
    }

    public double getCsrpxdot() {
        return this.covarianceMatrix.getEntry(7, 3);
    }

    public void setCsrpxdot(double CSRPXdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(7, 3, CSRPXdot);
    }

    public double getCsrpydot() {
        return this.covarianceMatrix.getEntry(7, 4);
    }

    public void setCsrpydot(double CSRPYdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(7, 4, CSRPYdot);
    }

    public double getCsrpzdot() {
        return this.covarianceMatrix.getEntry(7, 5);
    }

    public void setCsrpzdot(double CSRPZdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(7, 5, CSRPZdot);
    }

    public double getCsrpdrg() {
        return this.covarianceMatrix.getEntry(7, 6);
    }

    public void setCsrpdrg(double CSRPDRG) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(7, 6, CSRPDRG);
    }

    public double getCsrpsrp() {
        return this.covarianceMatrix.getEntry(7, 7);
    }

    public void setCsrpsrp(double CSRPSRP) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(7, 7, CSRPSRP);
    }

    public double getCthrx() {
        return this.covarianceMatrix.getEntry(8, 0);
    }

    public void setCthrx(double CTHRX) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 0, CTHRX);
    }

    public double getCthry() {
        return this.covarianceMatrix.getEntry(8, 1);
    }

    public void setCthry(double CTHRY) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 1, CTHRY);
    }

    public double getCthrz() {
        return this.covarianceMatrix.getEntry(8, 2);
    }

    public void setCthrz(double CTHRZ) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 2, CTHRZ);
    }

    public double getCthrxdot() {
        return this.covarianceMatrix.getEntry(8, 3);
    }

    public void setCthrxdot(double CTHRXdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 3, CTHRXdot);
    }

    public double getCthrydot() {
        return this.covarianceMatrix.getEntry(8, 4);
    }

    public void setCthrydot(double CTHRYdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 4, CTHRYdot);
    }

    public double getCthrzdot() {
        return this.covarianceMatrix.getEntry(8, 5);
    }

    public void setCthrzdot(double CTHRZdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 5, CTHRZdot);
    }

    public double getCthrdrg() {
        return this.covarianceMatrix.getEntry(8, 6);
    }

    public void setCthrdrg(double CTHRDRG) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 6, CTHRDRG);
    }

    public double getCthrsrp() {
        return this.covarianceMatrix.getEntry(8, 7);
    }

    public void setCthrsrp(double CTHRSRP) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 7, CTHRSRP);
    }

    public double getCthrthr() {
        return this.covarianceMatrix.getEntry(8, 8);
    }

    public void setCthrthr(double CTHRTHR) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 8, CTHRTHR);
    }

    public boolean isCovXYZset() {
        return this.covXYZset;
    }
}

