/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.files.ccsds.ndm.odm.StateVectorKey;
import org.orekit.files.ccsds.section.CommentsContainer;

public class StateVector
extends CommentsContainer {
    private double x = Double.NaN;
    private double y = Double.NaN;
    private double z = Double.NaN;
    private double xDot = Double.NaN;
    private double yDot = Double.NaN;
    private double zDot = Double.NaN;

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkNotNaN(this.x, StateVectorKey.X.name());
        this.checkNotNaN(this.y, StateVectorKey.Y.name());
        this.checkNotNaN(this.z, StateVectorKey.Z.name());
        this.checkNotNaN(this.xDot, StateVectorKey.X_DOT.name());
        this.checkNotNaN(this.yDot, StateVectorKey.Y_DOT.name());
        this.checkNotNaN(this.zDot, StateVectorKey.Z_DOT.name());
    }

    public void setX(double X) {
        this.refuseFurtherComments();
        this.x = X;
    }

    public void setY(double Y) {
        this.refuseFurtherComments();
        this.y = Y;
    }

    public void setZ(double Z) {
        this.refuseFurtherComments();
        this.z = Z;
    }

    public void setXdot(double Xdot) {
        this.refuseFurtherComments();
        this.xDot = Xdot;
    }

    public void setYdot(double Ydot) {
        this.refuseFurtherComments();
        this.yDot = Ydot;
    }

    public void setZdot(double Zdot) {
        this.refuseFurtherComments();
        this.zDot = Zdot;
    }

    public Vector3D getPositionVector() {
        return new Vector3D(this.x, this.y, this.z);
    }

    public Vector3D getVelocityVector() {
        return new Vector3D(this.xDot, this.yDot, this.zDot);
    }
}

