/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.cdm.CdmMetadataKey;
import org.orekit.files.ccsds.ndm.cdm.SigmaEigenvectorsCovarianceKey;
import org.orekit.files.ccsds.section.CommentsContainer;

public class SigmaEigenvectorsCovariance
extends CommentsContainer {
    private double[] csig3eigvec3;
    private boolean altCovFlag;

    public SigmaEigenvectorsCovariance(boolean altCovFlag) {
        this.altCovFlag = altCovFlag;
        this.csig3eigvec3 = new double[12];
        for (int i = 0; i < this.csig3eigvec3.length; ++i) {
            this.csig3eigvec3[i] = Double.NaN;
        }
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        if (!this.isAltCovFlagSet()) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, new Object[]{CdmMetadataKey.ALT_COV_TYPE});
        }
        for (int i = 0; i < this.getCsig3eigvec3().length; ++i) {
            this.checkNotNaN(this.getCsig3eigvec3()[i], SigmaEigenvectorsCovarianceKey.CSIG3EIGVEC3.name());
        }
    }

    public double[] getCsig3eigvec3() {
        return this.csig3eigvec3 == null ? null : (double[])this.csig3eigvec3.clone();
    }

    public void setCsig3eigvec3(double[] csig3eigvec3) {
        this.refuseFurtherComments();
        if (!this.isAltCovFlagSet()) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, new Object[]{CdmMetadataKey.ALT_COV_TYPE});
        }
        this.csig3eigvec3 = csig3eigvec3 == null ? null : (double[])csig3eigvec3.clone();
    }

    public boolean isAltCovFlagSet() {
        return this.altCovFlag;
    }
}

