/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.files.ccsds.ndm.cdm.RTNCovarianceKey;
import org.orekit.files.ccsds.section.CommentsContainer;

public class RTNCovariance
extends CommentsContainer {
    private RealMatrix covarianceMatrix = MatrixUtils.createRealMatrix((int)9, (int)9);

    public RTNCovariance() {
        for (int i = 0; i < this.covarianceMatrix.getRowDimension(); ++i) {
            for (int j = 0; j <= i; ++j) {
                this.covarianceMatrix.setEntry(i, j, Double.NaN);
            }
        }
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkNotNaN(this.getCrr(), RTNCovarianceKey.CR_R.name());
        this.checkNotNaN(this.getCtr(), RTNCovarianceKey.CT_R.name());
        this.checkNotNaN(this.getCtt(), RTNCovarianceKey.CT_T.name());
        this.checkNotNaN(this.getCnr(), RTNCovarianceKey.CN_R.name());
        this.checkNotNaN(this.getCnt(), RTNCovarianceKey.CN_T.name());
        this.checkNotNaN(this.getCnn(), RTNCovarianceKey.CN_N.name());
        this.checkNotNaN(this.getCrdotr(), RTNCovarianceKey.CRDOT_R.name());
        this.checkNotNaN(this.getCrdott(), RTNCovarianceKey.CRDOT_T.name());
        this.checkNotNaN(this.getCrdotn(), RTNCovarianceKey.CRDOT_N.name());
        this.checkNotNaN(this.getCrdotrdot(), RTNCovarianceKey.CRDOT_RDOT.name());
        this.checkNotNaN(this.getCtdotr(), RTNCovarianceKey.CTDOT_R.name());
        this.checkNotNaN(this.getCtdott(), RTNCovarianceKey.CTDOT_T.name());
        this.checkNotNaN(this.getCtdotn(), RTNCovarianceKey.CTDOT_N.name());
        this.checkNotNaN(this.getCtdotrdot(), RTNCovarianceKey.CTDOT_RDOT.name());
        this.checkNotNaN(this.getCtdottdot(), RTNCovarianceKey.CTDOT_TDOT.name());
        this.checkNotNaN(this.getCndotr(), RTNCovarianceKey.CNDOT_R.name());
        this.checkNotNaN(this.getCndott(), RTNCovarianceKey.CNDOT_T.name());
        this.checkNotNaN(this.getCndotn(), RTNCovarianceKey.CNDOT_N.name());
        this.checkNotNaN(this.getCndotrdot(), RTNCovarianceKey.CNDOT_RDOT.name());
        this.checkNotNaN(this.getCndottdot(), RTNCovarianceKey.CNDOT_TDOT.name());
        this.checkNotNaN(this.getCndotndot(), RTNCovarianceKey.CNDOT_NDOT.name());
    }

    public void setCovarianceMatrixEntry(int j, int k, double entry) {
        this.covarianceMatrix.setEntry(j, k, entry);
        this.covarianceMatrix.setEntry(k, j, entry);
    }

    public RealMatrix getRTNCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public double getCrr() {
        return this.covarianceMatrix.getEntry(0, 0);
    }

    public void setCrr(double CRR) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(0, 0, CRR);
    }

    public double getCtr() {
        return this.covarianceMatrix.getEntry(1, 0);
    }

    public void setCtr(double CTR) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(1, 0, CTR);
    }

    public double getCtt() {
        return this.covarianceMatrix.getEntry(1, 1);
    }

    public void setCtt(double CTT) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(1, 1, CTT);
    }

    public double getCnr() {
        return this.covarianceMatrix.getEntry(2, 0);
    }

    public void setCnr(double CNR) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(2, 0, CNR);
    }

    public double getCnt() {
        return this.covarianceMatrix.getEntry(2, 1);
    }

    public void setCnt(double CNT) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(2, 1, CNT);
    }

    public double getCnn() {
        return this.covarianceMatrix.getEntry(2, 2);
    }

    public void setCnn(double CNN) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(2, 2, CNN);
    }

    public double getCrdotr() {
        return this.covarianceMatrix.getEntry(3, 0);
    }

    public void setCrdotr(double CRdotR) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(3, 0, CRdotR);
    }

    public double getCrdott() {
        return this.covarianceMatrix.getEntry(3, 1);
    }

    public void setCrdott(double CRdotT) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(3, 1, CRdotT);
    }

    public double getCrdotn() {
        return this.covarianceMatrix.getEntry(3, 2);
    }

    public void setCrdotn(double CRdotN) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(3, 2, CRdotN);
    }

    public double getCrdotrdot() {
        return this.covarianceMatrix.getEntry(3, 3);
    }

    public void setCrdotrdot(double CRdotRdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(3, 3, CRdotRdot);
    }

    public double getCtdotr() {
        return this.covarianceMatrix.getEntry(4, 0);
    }

    public void setCtdotr(double CTdotR) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(4, 0, CTdotR);
    }

    public double getCtdott() {
        return this.covarianceMatrix.getEntry(4, 1);
    }

    public void setCtdott(double CTdotT) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(4, 1, CTdotT);
    }

    public double getCtdotn() {
        return this.covarianceMatrix.getEntry(4, 2);
    }

    public void setCtdotn(double CTdotN) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(4, 2, CTdotN);
    }

    public double getCtdotrdot() {
        return this.covarianceMatrix.getEntry(4, 3);
    }

    public void setCtdotrdot(double CTdotRdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(4, 3, CTdotRdot);
    }

    public double getCtdottdot() {
        return this.covarianceMatrix.getEntry(4, 4);
    }

    public void setCtdottdot(double CTdotTdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(4, 4, CTdotTdot);
    }

    public double getCndotr() {
        return this.covarianceMatrix.getEntry(5, 0);
    }

    public void setCndotr(double CNdotR) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(5, 0, CNdotR);
    }

    public double getCndott() {
        return this.covarianceMatrix.getEntry(5, 1);
    }

    public void setCndott(double CNdotT) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(5, 1, CNdotT);
    }

    public double getCndotn() {
        return this.covarianceMatrix.getEntry(5, 2);
    }

    public void setCndotn(double CNdotN) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(5, 2, CNdotN);
    }

    public double getCndotrdot() {
        return this.covarianceMatrix.getEntry(5, 3);
    }

    public void setCndotrdot(double CNdotRdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(5, 3, CNdotRdot);
    }

    public double getCndottdot() {
        return this.covarianceMatrix.getEntry(5, 4);
    }

    public void setCndottdot(double CNdotTdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(5, 4, CNdotTdot);
    }

    public double getCndotndot() {
        return this.covarianceMatrix.getEntry(5, 5);
    }

    public void setCndotndot(double CNdotNdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(5, 5, CNdotNdot);
    }

    public double getCdrgr() {
        return this.covarianceMatrix.getEntry(6, 0);
    }

    public void setCdrgr(double CDRGR) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(6, 0, CDRGR);
    }

    public double getCdrgt() {
        return this.covarianceMatrix.getEntry(6, 1);
    }

    public void setCdrgt(double CDRGT) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(6, 1, CDRGT);
    }

    public double getCdrgn() {
        return this.covarianceMatrix.getEntry(6, 2);
    }

    public void setCdrgn(double CDRGN) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(6, 2, CDRGN);
    }

    public double getCdrgrdot() {
        return this.covarianceMatrix.getEntry(6, 3);
    }

    public void setCdrgrdot(double CDRGRdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(6, 3, CDRGRdot);
    }

    public double getCdrgtdot() {
        return this.covarianceMatrix.getEntry(6, 4);
    }

    public void setCdrgtdot(double CDRGTdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(6, 4, CDRGTdot);
    }

    public double getCdrgndot() {
        return this.covarianceMatrix.getEntry(6, 5);
    }

    public void setCdrgndot(double CDRGNdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(6, 5, CDRGNdot);
    }

    public double getCdrgdrg() {
        return this.covarianceMatrix.getEntry(6, 6);
    }

    public void setCdrgdrg(double CDRGDRG) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(6, 6, CDRGDRG);
    }

    public double getCsrpr() {
        return this.covarianceMatrix.getEntry(7, 0);
    }

    public void setCsrpr(double CSRPR) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(7, 0, CSRPR);
    }

    public double getCsrpt() {
        return this.covarianceMatrix.getEntry(7, 1);
    }

    public void setCsrpt(double CSRPT) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(7, 1, CSRPT);
    }

    public double getCsrpn() {
        return this.covarianceMatrix.getEntry(7, 2);
    }

    public void setCsrpn(double CSRPN) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(7, 2, CSRPN);
    }

    public double getCsrprdot() {
        return this.covarianceMatrix.getEntry(7, 3);
    }

    public void setCsrprdot(double CSRPRdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(7, 3, CSRPRdot);
    }

    public double getCsrptdot() {
        return this.covarianceMatrix.getEntry(7, 4);
    }

    public void setCsrptdot(double CSRPTdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(7, 4, CSRPTdot);
    }

    public double getCsrpndot() {
        return this.covarianceMatrix.getEntry(7, 5);
    }

    public void setCsrpndot(double CSRPNdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(7, 5, CSRPNdot);
    }

    public double getCsrpdrg() {
        return this.covarianceMatrix.getEntry(7, 6);
    }

    public void setCsrpdrg(double CSRPDRG) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(7, 6, CSRPDRG);
    }

    public double getCsrpsrp() {
        return this.covarianceMatrix.getEntry(7, 7);
    }

    public void setCsrpsrp(double CSRPSRP) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(7, 7, CSRPSRP);
    }

    public double getCthrr() {
        return this.covarianceMatrix.getEntry(8, 0);
    }

    public void setCthrr(double CTHRR) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 0, CTHRR);
    }

    public double getCthrt() {
        return this.covarianceMatrix.getEntry(8, 1);
    }

    public void setCthrt(double CTHRT) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 1, CTHRT);
    }

    public double getCthrn() {
        return this.covarianceMatrix.getEntry(8, 2);
    }

    public void setCthrn(double CTHRN) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 2, CTHRN);
    }

    public double getCthrrdot() {
        return this.covarianceMatrix.getEntry(8, 3);
    }

    public void setCthrrdot(double CTHRRdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 3, CTHRRdot);
    }

    public double getCthrtdot() {
        return this.covarianceMatrix.getEntry(8, 4);
    }

    public void setCthrtdot(double CTHRTdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 4, CTHRTdot);
    }

    public double getCthrndot() {
        return this.covarianceMatrix.getEntry(8, 5);
    }

    public void setCthrndot(double CTHRNdot) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 5, CTHRNdot);
    }

    public double getCthrdrg() {
        return this.covarianceMatrix.getEntry(8, 6);
    }

    public void setCthrdrg(double CTHRDRG) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 6, CTHRDRG);
    }

    public double getCthrsrp() {
        return this.covarianceMatrix.getEntry(8, 7);
    }

    public void setCthrsrp(double CTHRSRP) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 7, CTHRSRP);
    }

    public double getCthrthr() {
        return this.covarianceMatrix.getEntry(8, 8);
    }

    public void setCthrthr(double CTHRTHR) {
        this.refuseFurtherComments();
        this.setCovarianceMatrixEntry(8, 8, CTHRTHR);
    }
}

