/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.cdm.ODParameters;
import org.orekit.files.ccsds.ndm.cdm.ODParametersKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.units.Unit;

public class ODParametersWriter
extends AbstractWriter {
    private final ODParameters ODparameters;
    private final TimeConverter timeConverter;

    ODParametersWriter(String xmlTag, String kvnTag, ODParameters ODParameters2, TimeConverter timeConverter) {
        super(xmlTag, kvnTag);
        this.ODparameters = ODParameters2;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.ODparameters.getComments());
        generator.writeEntry(ODParametersKey.TIME_LASTOB_START.name(), this.timeConverter, this.ODparameters.getTimeLastObsStart(), true, false);
        generator.writeEntry(ODParametersKey.TIME_LASTOB_END.name(), this.timeConverter, this.ODparameters.getTimeLastObsEnd(), true, false);
        generator.writeEntry(ODParametersKey.RECOMMENDED_OD_SPAN.name(), this.ODparameters.getRecommendedOdSpan(), Unit.DAY, false);
        generator.writeEntry(ODParametersKey.ACTUAL_OD_SPAN.name(), this.ODparameters.getActualOdSpan(), Unit.DAY, false);
        generator.writeEntry(ODParametersKey.OBS_AVAILABLE.name(), this.ODparameters.getObsAvailable(), false);
        generator.writeEntry(ODParametersKey.OBS_USED.name(), this.ODparameters.getObsUsed(), false);
        generator.writeEntry(ODParametersKey.TRACKS_AVAILABLE.name(), this.ODparameters.getTracksAvailable(), false);
        generator.writeEntry(ODParametersKey.TRACKS_USED.name(), this.ODparameters.getTracksUsed(), false);
        generator.writeEntry(ODParametersKey.RESIDUALS_ACCEPTED.name(), this.ODparameters.getResidualsAccepted(), Unit.PERCENT, false);
        generator.writeEntry(ODParametersKey.WEIGHTED_RMS.name(), this.ODparameters.getWeightedRMS(), Unit.ONE, false);
    }
}

