/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import java.io.IOException;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.cdm.AdditionalParametersWriter;
import org.orekit.files.ccsds.ndm.cdm.CdmData;
import org.orekit.files.ccsds.ndm.cdm.CdmMessageWriter;
import org.orekit.files.ccsds.ndm.cdm.CdmMetadata;
import org.orekit.files.ccsds.ndm.cdm.CdmMetadataWriter;
import org.orekit.files.ccsds.ndm.cdm.CdmRelativeMetadata;
import org.orekit.files.ccsds.ndm.cdm.CdmRelativeMetadataKey;
import org.orekit.files.ccsds.ndm.cdm.ODParametersWriter;
import org.orekit.files.ccsds.ndm.cdm.RTNCovarianceWriter;
import org.orekit.files.ccsds.ndm.cdm.StateVectorWriter;
import org.orekit.files.ccsds.ndm.cdm.XmlSubStructureKey;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.units.Unit;

public class CdmWriter
extends CdmMessageWriter {
    public static final double CCSDS_CDM_VERS = 1.0;
    public static final int KVN_PADDING_WIDTH = 17;
    private final Vector3D NANVECTOR = new Vector3D(Double.NaN, Double.NaN, Double.NaN);

    public CdmWriter(IERSConventions conventions, DataContext dataContext) {
        super("cdm", "CCSDS_CDM_VERS", 1.0, new ContextBinding(() -> conventions, () -> false, () -> dataContext, () -> ParsedUnitsBehavior.STRICT_COMPLIANCE, () -> null, () -> TimeSystem.UTC, () -> 0.0, () -> 1.0));
    }

    @Override
    public void writeSegmentContent(Generator generator, double formatVersion, Segment<CdmMetadata, CdmData> segment) throws IOException {
        ContextBinding oldContext = this.getContext();
        CdmMetadata metadata = segment.getMetadata();
        this.setContext(new ContextBinding(oldContext::getConventions, oldContext::isSimpleEOP, oldContext::getDataContext, oldContext::getParsedUnitsBehavior, oldContext::getReferenceDate, metadata::getTimeSystem, oldContext::getClockCount, oldContext::getClockRate));
        new CdmMetadataWriter(metadata).write(generator);
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(XmlStructureKey.data.name());
        }
        if (segment.getData().getODParametersBlock() != null) {
            generator.writeComments(segment.getData().getComments());
            new ODParametersWriter(XmlSubStructureKey.odParameters.name(), null, segment.getData().getODParametersBlock(), this.getTimeConverter()).write(generator);
        }
        if (segment.getData().getAdditionalParametersBlock() != null) {
            new AdditionalParametersWriter(XmlSubStructureKey.additionalParameters.name(), null, segment.getData().getAdditionalParametersBlock()).write(generator);
        }
        new StateVectorWriter(XmlSubStructureKey.stateVector.name(), null, segment.getData().getStateVectorBlock()).write(generator);
        new RTNCovarianceWriter(XmlSubStructureKey.covarianceMatrix.name(), null, segment.getData().getRTNCovarianceBlock()).write(generator);
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
    }

    @Override
    public void writeRelativeMetadataContent(Generator generator, double formatVersion, CdmRelativeMetadata relativeMetadata) throws IOException {
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(XmlSubStructureKey.relativeMetadataData.name());
        }
        generator.writeComments(relativeMetadata.getComment());
        generator.writeEntry(CdmRelativeMetadataKey.TCA.name(), this.getTimeConverter(), relativeMetadata.getTca(), true, true);
        generator.writeEntry(CdmRelativeMetadataKey.MISS_DISTANCE.name(), relativeMetadata.getMissDistance(), Unit.METRE, true);
        generator.writeEntry(CdmRelativeMetadataKey.RELATIVE_SPEED.name(), relativeMetadata.getRelativeSpeed(), Units.M_PER_S, false);
        if (generator.getFormat() == FileFormat.XML && (relativeMetadata.getRelativePosition() != this.NANVECTOR || relativeMetadata.getRelativeVelocity() != this.NANVECTOR)) {
            generator.enterSection(XmlSubStructureKey.relativeStateVector.name());
        }
        if (relativeMetadata.getRelativePosition() != this.NANVECTOR) {
            generator.writeEntry(CdmRelativeMetadataKey.RELATIVE_POSITION_R.name(), relativeMetadata.getRelativePosition().getX(), Unit.METRE, false);
            generator.writeEntry(CdmRelativeMetadataKey.RELATIVE_POSITION_T.name(), relativeMetadata.getRelativePosition().getY(), Unit.METRE, false);
            generator.writeEntry(CdmRelativeMetadataKey.RELATIVE_POSITION_N.name(), relativeMetadata.getRelativePosition().getZ(), Unit.METRE, false);
        }
        if (relativeMetadata.getRelativeVelocity() != this.NANVECTOR) {
            generator.writeEntry(CdmRelativeMetadataKey.RELATIVE_VELOCITY_R.name(), relativeMetadata.getRelativeVelocity().getX(), Units.M_PER_S, false);
            generator.writeEntry(CdmRelativeMetadataKey.RELATIVE_VELOCITY_T.name(), relativeMetadata.getRelativeVelocity().getY(), Units.M_PER_S, false);
            generator.writeEntry(CdmRelativeMetadataKey.RELATIVE_VELOCITY_N.name(), relativeMetadata.getRelativeVelocity().getZ(), Units.M_PER_S, false);
        }
        if (generator.getFormat() == FileFormat.XML && (relativeMetadata.getRelativePosition() != this.NANVECTOR || relativeMetadata.getRelativeVelocity() != this.NANVECTOR)) {
            generator.exitSection();
        }
        generator.writeEntry(CdmRelativeMetadataKey.START_SCREEN_PERIOD.name(), this.getTimeConverter(), relativeMetadata.getStartScreenPeriod(), true, false);
        generator.writeEntry(CdmRelativeMetadataKey.STOP_SCREEN_PERIOD.name(), this.getTimeConverter(), relativeMetadata.getStopScreenPeriod(), true, false);
        generator.writeEntry(CdmRelativeMetadataKey.SCREEN_VOLUME_FRAME.name(), relativeMetadata.getScreenVolumeFrame(), false);
        generator.writeEntry(CdmRelativeMetadataKey.SCREEN_VOLUME_SHAPE.name(), relativeMetadata.getScreenVolumeShape(), false);
        generator.writeEntry(CdmRelativeMetadataKey.SCREEN_VOLUME_X.name(), relativeMetadata.getScreenVolumeX(), Unit.METRE, false);
        generator.writeEntry(CdmRelativeMetadataKey.SCREEN_VOLUME_Y.name(), relativeMetadata.getScreenVolumeY(), Unit.METRE, false);
        generator.writeEntry(CdmRelativeMetadataKey.SCREEN_VOLUME_Z.name(), relativeMetadata.getScreenVolumeZ(), Unit.METRE, false);
        generator.writeEntry(CdmRelativeMetadataKey.SCREEN_ENTRY_TIME.name(), this.getTimeConverter(), relativeMetadata.getScreenEntryTime(), true, false);
        generator.writeEntry(CdmRelativeMetadataKey.SCREEN_EXIT_TIME.name(), this.getTimeConverter(), relativeMetadata.getScreenExitTime(), true, false);
        generator.writeEntry(CdmRelativeMetadataKey.COLLISION_PROBABILITY.name(), relativeMetadata.getCollisionProbability(), Unit.ONE, false);
        if (relativeMetadata.getCollisionProbaMethod() != null) {
            generator.writeEntry(CdmRelativeMetadataKey.COLLISION_PROBABILITY_METHOD.name(), relativeMetadata.getCollisionProbaMethod().getName(), null, false);
        }
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
    }
}

