/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.PocMethodFacade;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.ndm.cdm.CdmRelativeMetadataKey;
import org.orekit.files.ccsds.ndm.cdm.ScreenType;
import org.orekit.files.ccsds.ndm.cdm.ScreenVolumeFrame;
import org.orekit.files.ccsds.ndm.cdm.ScreenVolumeShape;
import org.orekit.time.AbsoluteDate;

public class CdmRelativeMetadata {
    private TimeSystem timeSystem;
    private List<String> comment = new ArrayList<String>();
    private AbsoluteDate tca;
    private double missDistance;
    private double relativeSpeed = Double.NaN;
    private double mahalanobisDistance;
    private double relativePositionR = Double.NaN;
    private double relativePositionT = Double.NaN;
    private double relativePositionN = Double.NaN;
    private double relativeVelocityR = Double.NaN;
    private double relativeVelocityT = Double.NaN;
    private double relativeVelocityN = Double.NaN;
    private AbsoluteDate startScreenPeriod;
    private AbsoluteDate stopScreenPeriod;
    private ScreenVolumeShape screenVolumeShape;
    private double screenVolumeRadius;
    private ScreenVolumeFrame screenVolumeFrame;
    private double screenVolumeX;
    private double screenVolumeY;
    private double screenVolumeZ;
    private AbsoluteDate screenEntryTime;
    private AbsoluteDate screenExitTime;
    private double collisionProbability;
    private PocMethodFacade collisionProbabilityMethod;
    private String conjunctionId;
    private double approachAngle = Double.NaN;
    private ScreenType screenType;
    private double maxCollisionProbability;
    private PocMethodFacade maxCollisionProbabilityMethod;
    private double sefiCollisionProbability;
    private PocMethodFacade sefiCollisionProbabilityMethod;
    private String sefiFragmentationModel;
    private double screenPcThreshold;
    private int[] collisionPercentile;
    private String previousMessageId;
    private AbsoluteDate previousMessageEpoch;
    private AbsoluteDate nextMessageEpoch;

    public CdmRelativeMetadata() {
        this.screenVolumeRadius = Double.NaN;
        this.screenPcThreshold = Double.NaN;
        this.mahalanobisDistance = Double.NaN;
        this.screenVolumeX = Double.NaN;
        this.screenVolumeY = Double.NaN;
        this.screenVolumeZ = Double.NaN;
        this.collisionProbability = Double.NaN;
        this.maxCollisionProbability = Double.NaN;
        this.sefiCollisionProbability = Double.NaN;
    }

    public void validate() {
        this.checkNotNull(this.tca, CdmRelativeMetadataKey.TCA);
        this.checkNotNull(this.missDistance, CdmRelativeMetadataKey.MISS_DISTANCE);
        this.checkScreenVolumeConditions();
    }

    public String getConjunctionId() {
        return this.conjunctionId;
    }

    public void setConjunctionId(String conjunctionId) {
        this.conjunctionId = conjunctionId;
    }

    public AbsoluteDate getTca() {
        return this.tca;
    }

    public void setTca(AbsoluteDate tca) {
        this.tca = tca;
    }

    public double getMissDistance() {
        return this.missDistance;
    }

    public void setMissDistance(double missDistance) {
        this.missDistance = missDistance;
    }

    public double getRelativeSpeed() {
        return this.relativeSpeed;
    }

    public void setRelativeSpeed(double relativeSpeed) {
        this.relativeSpeed = relativeSpeed;
    }

    public Vector3D getRelativeVelocity() {
        return new Vector3D(this.relativeVelocityR, this.relativeVelocityT, this.relativeVelocityN);
    }

    public Vector3D getRelativePosition() {
        return new Vector3D(this.relativePositionR, this.relativePositionT, this.relativePositionN);
    }

    public void setRelativePositionR(double relativePositionR) {
        this.relativePositionR = relativePositionR;
    }

    public void setRelativePositionT(double relativePositionT) {
        this.relativePositionT = relativePositionT;
    }

    public void setRelativePositionN(double relativePositionN) {
        this.relativePositionN = relativePositionN;
    }

    public void setRelativeVelocityR(double relativeVelocityR) {
        this.relativeVelocityR = relativeVelocityR;
    }

    public void setRelativeVelocityT(double relativeVelocityT) {
        this.relativeVelocityT = relativeVelocityT;
    }

    public void setRelativeVelocityN(double relativeVelocityN) {
        this.relativeVelocityN = relativeVelocityN;
    }

    public AbsoluteDate getStartScreenPeriod() {
        return this.startScreenPeriod;
    }

    public void setStartScreenPeriod(AbsoluteDate startScreenPeriod) {
        this.startScreenPeriod = startScreenPeriod;
    }

    public AbsoluteDate getStopScreenPeriod() {
        return this.stopScreenPeriod;
    }

    public void setStopScreenPeriod(AbsoluteDate stopScreenPeriod) {
        this.stopScreenPeriod = stopScreenPeriod;
    }

    public ScreenVolumeFrame getScreenVolumeFrame() {
        return this.screenVolumeFrame;
    }

    public void setScreenVolumeFrame(ScreenVolumeFrame screenVolumeFrame) {
        this.screenVolumeFrame = screenVolumeFrame;
    }

    public ScreenVolumeShape getScreenVolumeShape() {
        return this.screenVolumeShape;
    }

    public void setScreenVolumeShape(ScreenVolumeShape screenVolumeShape) {
        this.screenVolumeShape = screenVolumeShape;
    }

    public double getScreenVolumeX() {
        return this.screenVolumeX;
    }

    public void setScreenVolumeX(double screenVolumeX) {
        this.screenVolumeX = screenVolumeX;
    }

    public double getScreenVolumeY() {
        return this.screenVolumeY;
    }

    public void setScreenVolumeY(double screenVolumeY) {
        this.screenVolumeY = screenVolumeY;
    }

    public double getScreenVolumeZ() {
        return this.screenVolumeZ;
    }

    public void setScreenVolumeZ(double screenVolumeZ) {
        this.screenVolumeZ = screenVolumeZ;
    }

    public AbsoluteDate getScreenEntryTime() {
        return this.screenEntryTime;
    }

    public void setScreenEntryTime(AbsoluteDate screenEntryTime) {
        this.screenEntryTime = screenEntryTime;
    }

    public AbsoluteDate getScreenExitTime() {
        return this.screenExitTime;
    }

    public void setScreenExitTime(AbsoluteDate screenExitTime) {
        this.screenExitTime = screenExitTime;
    }

    public double getCollisionProbability() {
        return this.collisionProbability;
    }

    public void setCollisionProbability(double collisionProbability) {
        this.collisionProbability = collisionProbability;
    }

    public PocMethodFacade getCollisionProbaMethod() {
        return this.collisionProbabilityMethod;
    }

    public void setCollisionProbaMethod(PocMethodFacade collisionProbaMethod) {
        this.collisionProbabilityMethod = collisionProbaMethod;
    }

    public void checkNotNull(Object field, Enum<?> key) {
        if (field == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, key.name());
        }
    }

    public void setTimeSystem(TimeSystem timeSystem) {
        this.timeSystem = timeSystem;
    }

    public TimeSystem getTimeSystem() {
        return this.timeSystem;
    }

    public void addComment(String comments) {
        this.comment.add(comments);
    }

    public List<String> getComment() {
        return this.comment;
    }

    public double getApproachAngle() {
        return this.approachAngle;
    }

    public void setApproachAngle(double approachAngle) {
        this.approachAngle = approachAngle;
    }

    public ScreenType getScreenType() {
        return this.screenType;
    }

    public void setScreenType(ScreenType screenType) {
        this.screenType = screenType;
    }

    public double getMaxCollisionProbability() {
        return this.maxCollisionProbability;
    }

    public void setMaxCollisionProbability(double maxCollisionProbability) {
        this.maxCollisionProbability = maxCollisionProbability;
    }

    public PocMethodFacade getMaxCollisionProbabilityMethod() {
        return this.maxCollisionProbabilityMethod;
    }

    public void setMaxCollisionProbabilityMethod(PocMethodFacade pocMethodFacade) {
        this.maxCollisionProbabilityMethod = pocMethodFacade;
    }

    public double getSefiCollisionProbability() {
        return this.sefiCollisionProbability;
    }

    public void setSefiCollisionProbability(double sefiCollisionProbability) {
        this.sefiCollisionProbability = sefiCollisionProbability;
    }

    public PocMethodFacade getSefiCollisionProbabilityMethod() {
        return this.sefiCollisionProbabilityMethod;
    }

    public void setSefiCollisionProbabilityMethod(PocMethodFacade pocMethodFacade) {
        this.sefiCollisionProbabilityMethod = pocMethodFacade;
    }

    public String getSefiFragmentationModel() {
        return this.sefiFragmentationModel;
    }

    public void setSefiFragmentationModel(String sefiFragmentationModel) {
        this.sefiFragmentationModel = sefiFragmentationModel;
    }

    public double getMahalanobisDistance() {
        return this.mahalanobisDistance;
    }

    public void setMahalanobisDistance(double mahalanobisDistance) {
        this.mahalanobisDistance = mahalanobisDistance;
    }

    public double getScreenVolumeRadius() {
        return this.screenVolumeRadius;
    }

    public void setScreenVolumeRadius(double screenVolumeRadius) {
        this.screenVolumeRadius = screenVolumeRadius;
    }

    public double getScreenPcThreshold() {
        return this.screenPcThreshold;
    }

    public void setScreenPcThreshold(double screenPcThreshold) {
        this.screenPcThreshold = screenPcThreshold;
    }

    public void checkScreenVolumeConditions() {
        if (this.getScreenType() == ScreenType.SHAPE) {
            if (this.getScreenEntryTime() == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_MISSING_KEYWORD, new Object[]{CdmRelativeMetadataKey.SCREEN_ENTRY_TIME});
            }
            if (this.getScreenExitTime() == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_MISSING_KEYWORD, new Object[]{CdmRelativeMetadataKey.SCREEN_EXIT_TIME});
            }
            if (this.getScreenVolumeShape() == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_MISSING_KEYWORD, new Object[]{CdmRelativeMetadataKey.SCREEN_VOLUME_SHAPE});
            }
            if (this.getScreenVolumeShape() == ScreenVolumeShape.SPHERE) {
                if (Double.isNaN(this.getScreenVolumeRadius())) {
                    throw new OrekitException((Localizable)OrekitMessages.CCSDS_MISSING_KEYWORD, new Object[]{CdmRelativeMetadataKey.SCREEN_VOLUME_RADIUS});
                }
            } else if (this.getScreenVolumeShape() == ScreenVolumeShape.ELLIPSOID || this.getScreenVolumeShape() == ScreenVolumeShape.BOX) {
                if (this.getScreenVolumeFrame() == null) {
                    throw new OrekitException((Localizable)OrekitMessages.CCSDS_MISSING_KEYWORD, new Object[]{CdmRelativeMetadataKey.SCREEN_VOLUME_FRAME});
                }
                if (Double.isNaN(this.getScreenVolumeX())) {
                    throw new OrekitException((Localizable)OrekitMessages.CCSDS_MISSING_KEYWORD, new Object[]{CdmRelativeMetadataKey.SCREEN_VOLUME_X});
                }
                if (Double.isNaN(this.getScreenVolumeY())) {
                    throw new OrekitException((Localizable)OrekitMessages.CCSDS_MISSING_KEYWORD, new Object[]{CdmRelativeMetadataKey.SCREEN_VOLUME_Y});
                }
                if (Double.isNaN(this.getScreenVolumeZ())) {
                    throw new OrekitException((Localizable)OrekitMessages.CCSDS_MISSING_KEYWORD, new Object[]{CdmRelativeMetadataKey.SCREEN_VOLUME_Z});
                }
            }
        } else if ((this.getScreenType() == ScreenType.PC || this.getScreenType() == ScreenType.PC_MAX) && Double.isNaN(this.getScreenPcThreshold())) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_MISSING_KEYWORD, new Object[]{CdmRelativeMetadataKey.SCREEN_PC_THRESHOLD});
        }
    }

    public int[] getCollisionPercentile() {
        return this.collisionPercentile == null ? null : (int[])this.collisionPercentile.clone();
    }

    public void setCollisionPercentile(int[] collisionPercentile) {
        this.collisionPercentile = collisionPercentile == null ? null : (int[])collisionPercentile.clone();
    }

    public String getPreviousMessageId() {
        return this.previousMessageId;
    }

    public void setPreviousMessageId(String previousMessageId) {
        this.previousMessageId = previousMessageId;
    }

    public AbsoluteDate getPreviousMessageEpoch() {
        return this.previousMessageEpoch;
    }

    public void setPreviousMessageEpoch(AbsoluteDate previousMessageEpoch) {
        this.previousMessageEpoch = previousMessageEpoch;
    }

    public AbsoluteDate getNextMessageEpoch() {
        return this.nextMessageEpoch;
    }

    public void setNextMessageEpoch(AbsoluteDate nextMessageEpoch) {
        this.nextMessageEpoch = nextMessageEpoch;
    }
}

