/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import java.io.IOException;
import java.util.ArrayList;
import org.orekit.files.ccsds.definitions.BodyFacade;
import org.orekit.files.ccsds.ndm.cdm.CdmMetadata;
import org.orekit.files.ccsds.ndm.cdm.CdmMetadataKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.generation.Generator;

public class CdmMetadataWriter
extends AbstractWriter {
    private final CdmMetadata metadata;

    public CdmMetadataWriter(CdmMetadata metadata) {
        super(XmlStructureKey.metadata.name(), null);
        this.metadata = metadata;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.metadata.getComments());
        generator.writeEntry(CdmMetadataKey.OBJECT.name(), this.metadata.getObject(), null, true);
        generator.writeEntry(CdmMetadataKey.OBJECT_DESIGNATOR.name(), this.metadata.getObjectDesignator(), null, true);
        generator.writeEntry(CdmMetadataKey.CATALOG_NAME.name(), this.metadata.getCatalogName(), null, true);
        generator.writeEntry(CdmMetadataKey.OBJECT_NAME.name(), this.metadata.getObjectName(), null, true);
        generator.writeEntry(CdmMetadataKey.INTERNATIONAL_DESIGNATOR.name(), this.metadata.getInternationalDes(), null, true);
        generator.writeEntry(CdmMetadataKey.OBJECT_TYPE.name(), this.metadata.getObjectType(), false);
        generator.writeEntry(CdmMetadataKey.OPERATOR_CONTACT_POSITION.name(), this.metadata.getOperatorContactPosition(), null, false);
        generator.writeEntry(CdmMetadataKey.OPERATOR_ORGANIZATION.name(), this.metadata.getOperatorOrganization(), null, false);
        generator.writeEntry(CdmMetadataKey.OPERATOR_PHONE.name(), this.metadata.getOperatorPhone(), null, false);
        generator.writeEntry(CdmMetadataKey.OPERATOR_EMAIL.name(), this.metadata.getOperatorEmail(), null, false);
        generator.writeEntry(CdmMetadataKey.EPHEMERIS_NAME.name(), this.metadata.getEphemName(), null, true);
        generator.writeEntry(CdmMetadataKey.COVARIANCE_METHOD.name(), this.metadata.getCovarianceMethod(), true);
        generator.writeEntry(CdmMetadataKey.MANEUVERABLE.name(), this.metadata.getManeuverable().getValue(), null, true);
        if (this.metadata.getOrbitCenter() != null) {
            generator.writeEntry(CdmMetadataKey.ORBIT_CENTER.name(), this.metadata.getOrbitCenter().getName(), null, false);
        }
        generator.writeEntry(CdmMetadataKey.REF_FRAME.name(), this.metadata.getRefFrame().getName(), null, true);
        if (this.metadata.getGravityModel() != null) {
            String model = this.metadata.getGravityModel() + ": " + this.metadata.getGravityDegree() + "D " + this.metadata.getGravityOrder() + 'O';
            generator.writeEntry(CdmMetadataKey.GRAVITY_MODEL.name(), model, null, false);
        }
        generator.writeEntry(CdmMetadataKey.ATMOSPHERIC_MODEL.name(), this.metadata.getAtmosphericModel(), null, false);
        if (this.metadata.getNBodyPerturbations() != null && !this.metadata.getNBodyPerturbations().isEmpty()) {
            ArrayList<String> names = new ArrayList<String>();
            for (BodyFacade bf : this.metadata.getNBodyPerturbations()) {
                names.add(bf.getName());
            }
            generator.writeEntry(CdmMetadataKey.N_BODY_PERTURBATIONS.name(), names, false);
        }
        if (this.metadata.getSolarRadiationPressure() != null) {
            generator.writeEntry(CdmMetadataKey.SOLAR_RAD_PRESSURE.name(), this.metadata.getSolarRadiationPressure().name(), null, false);
        }
        if (this.metadata.getEarthTides() != null) {
            generator.writeEntry(CdmMetadataKey.EARTH_TIDES.name(), this.metadata.getEarthTides().name(), null, false);
        }
        if (this.metadata.getIntrackThrust() != null) {
            generator.writeEntry(CdmMetadataKey.INTRACK_THRUST.name(), this.metadata.getIntrackThrust().name(), null, false);
        }
    }
}

