/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.orekit.files.ccsds.definitions.YesNoUnknown;
import org.orekit.files.ccsds.ndm.cdm.AltCovarianceType;
import org.orekit.files.ccsds.ndm.cdm.CdmMetadata;
import org.orekit.files.ccsds.ndm.cdm.CovarianceMethod;
import org.orekit.files.ccsds.ndm.odm.ocm.ObjectType;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;

public enum CdmMetadataKey {
    OBJECT((token, context, container) -> token.processAsNormalizedString(container::setObject)),
    OBJECT_DESIGNATOR((token, context, container) -> token.processAsNormalizedString(container::setObjectDesignator)),
    CATALOG_NAME((token, context, container) -> token.processAsNormalizedString(container::setCatalogName)),
    OBJECT_NAME((token, context, container) -> token.processAsNormalizedString(container::setObjectName)),
    INTERNATIONAL_DESIGNATOR((token, context, container) -> token.processAsNormalizedString(container::setInternationalDes)),
    OBJECT_TYPE((token, context, container) -> token.processAsEnum(ObjectType.class, container::setObjectType)),
    OPERATOR_CONTACT_POSITION((token, context, container) -> token.processAsNormalizedString(container::setOperatorContactPosition)),
    OPERATOR_ORGANIZATION((token, context, container) -> token.processAsNormalizedString(container::setOperatorOrganization)),
    OPERATOR_PHONE((token, context, container) -> token.processAsNormalizedString(container::setOperatorPhone)),
    OPERATOR_EMAIL((token, context, container) -> token.processAsNormalizedString(container::setOperatorEmail)),
    ODM_MSG_LINK((token, context, container) -> token.processAsFreeTextString(container::setOdmMsgLink)),
    ADM_MSG_LINK((token, context, container) -> token.processAsFreeTextString(container::setAdmMsgLink)),
    EPHEMERIS_NAME((token, context, container) -> token.processAsNormalizedString(container::setEphemName)),
    OBS_BEFORE_NEXT_MESSAGE((token, context, container) -> token.processAsEnum(YesNoUnknown.class, container::setObsBeforeNextMessage)),
    COVARIANCE_METHOD((token, context, container) -> token.processAsEnum(CovarianceMethod.class, container::setCovarianceMethod)),
    COVARIANCE_SOURCE((token, context, container) -> token.processAsNormalizedString(container::setCovarianceSource)),
    MANEUVERABLE((token, context, container) -> token.processAsManeuvrableEnum(container::setManeuverable)),
    ORBIT_CENTER((token, context, container) -> token.processAsCenter(container::setOrbitCenter, context.getDataContext().getCelestialBodies())),
    REF_FRAME((token, context, container) -> token.processAsFrame(container::setRefFrame, context, true, true, true)),
    ALT_COV_TYPE((token, context, container) -> token.processAsEnum(AltCovarianceType.class, container::setAltCovType)),
    ALT_COV_REF_FRAME((token, context, container) -> token.processAsFrame(container::setAltCovRefFrame, context, true, false, false)),
    GRAVITY_MODEL(new GravityProcessor()),
    ATMOSPHERIC_MODEL((token, context, container) -> token.processAsNormalizedString(container::setAtmosphericModel)),
    N_BODY_PERTURBATIONS((token, context, container) -> token.processAsCenterList(container::setNBodyPerturbations, context.getDataContext().getCelestialBodies())),
    SOLAR_RAD_PRESSURE((token, context, container) -> token.processAsEnum(YesNoUnknown.class, container::setSolarRadiationPressure)),
    EARTH_TIDES((token, context, container) -> token.processAsEnum(YesNoUnknown.class, container::setEarthTides)),
    INTRACK_THRUST((token, context, container) -> token.processAsEnum(YesNoUnknown.class, container::setIntrackThrust));

    private final transient TokenProcessor processor;

    private CdmMetadataKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, CdmMetadata container) {
        return this.processor.process(token, context, container);
    }

    private static class GravityProcessor
    implements TokenProcessor {
        private static final Pattern GRAVITY_PATTERN = Pattern.compile("^\\p{Blank}*([-_A-Za-z0-9]+)\\p{Blank}*:\\p{Blank}*([0-9]+)D\\p{Blank}*([0-9]+)O\\p{Blank}*$");

        private GravityProcessor() {
        }

        @Override
        public boolean process(ParseToken token, ContextBinding context, CdmMetadata container) {
            if (token.getType() == TokenType.ENTRY) {
                Matcher matcher = GRAVITY_PATTERN.matcher(token.getContentAsNormalizedString());
                if (!matcher.matches()) {
                    throw token.generateException(null);
                }
                container.setGravityModel(matcher.group(1), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
            }
            return true;
        }
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, CdmMetadata var3);
    }
}

