/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import java.util.List;
import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.CelestialBody;
import org.orekit.bodies.CelestialBodyFactory;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.BodyFacade;
import org.orekit.files.ccsds.definitions.CelestialBodyFrame;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.definitions.ModifiedFrame;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.definitions.YesNoUnknown;
import org.orekit.files.ccsds.ndm.cdm.AltCovarianceType;
import org.orekit.files.ccsds.ndm.cdm.CdmMetadataKey;
import org.orekit.files.ccsds.ndm.cdm.CdmRelativeMetadata;
import org.orekit.files.ccsds.ndm.cdm.CovarianceMethod;
import org.orekit.files.ccsds.ndm.cdm.Maneuvrable;
import org.orekit.files.ccsds.ndm.odm.ocm.ObjectType;
import org.orekit.files.ccsds.section.Metadata;
import org.orekit.frames.Frame;

public class CdmMetadata
extends Metadata {
    private CdmRelativeMetadata relativeMetadata;
    private String object;
    private String objectDesignator;
    private String catalogName;
    private String objectName;
    private String internationalDesignator;
    private ObjectType objectType;
    private String operatorContact;
    private String operatorOrganization;
    private String operatorPhone;
    private String operatorEmail;
    private String odmMsgLink;
    private String admMsgLink;
    private String ephemName;
    private YesNoUnknown obsBeforeNextMessage;
    private CovarianceMethod covarianceMethod;
    private Maneuvrable maneuverable;
    private BodyFacade orbitCenter;
    private FrameFacade refFrame;
    private String gravityModel;
    private int gravityDegree;
    private int gravityOrder;
    private String atmosphericModel;
    private List<BodyFacade> nBodyPerturbations;
    private YesNoUnknown isSolarRadPressure;
    private YesNoUnknown isEarthTides;
    private YesNoUnknown isIntrackThrustModeled;
    private String covarianceSource;
    private AltCovarianceType altCovType;
    private FrameFacade altCovRefFrame;

    @DefaultDataContext
    public CdmMetadata() {
        super(null);
        this.orbitCenter = new BodyFacade("Earth".toUpperCase(), CelestialBodyFactory.getEarth());
    }

    public CdmMetadata(DataContext dataContext) {
        super(null);
        CelestialBody earth = dataContext.getCelestialBodies().getEarth();
        this.orbitCenter = new BodyFacade(earth.getName().toUpperCase(), earth);
    }

    @Override
    public void validate(double version) {
        this.checkNotNull(this.object, CdmMetadataKey.OBJECT.name());
        this.checkNotNull(this.objectDesignator, CdmMetadataKey.OBJECT_DESIGNATOR.name());
        this.checkNotNull(this.catalogName, CdmMetadataKey.CATALOG_NAME.name());
        this.checkNotNull(this.objectName, CdmMetadataKey.OBJECT_NAME.name());
        this.checkNotNull(this.internationalDesignator, CdmMetadataKey.INTERNATIONAL_DESIGNATOR.name());
        this.checkNotNull(this.ephemName, CdmMetadataKey.EPHEMERIS_NAME.name());
        this.checkNotNull((Object)this.covarianceMethod, CdmMetadataKey.COVARIANCE_METHOD.name());
        this.checkNotNull((Object)this.maneuverable, CdmMetadataKey.MANEUVERABLE.name());
        this.checkNotNull(this.refFrame, CdmMetadataKey.REF_FRAME.name());
    }

    public CdmRelativeMetadata getRelativeMetadata() {
        return this.relativeMetadata;
    }

    public void setRelativeMetadata(CdmRelativeMetadata relativeMetadata) {
        this.relativeMetadata = relativeMetadata;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.setTimeSystem(TimeSystem.UTC);
        this.refuseFurtherComments();
        this.object = object;
    }

    public String getObjectDesignator() {
        return this.objectDesignator;
    }

    public void setObjectDesignator(String objectDesignator) {
        this.refuseFurtherComments();
        this.objectDesignator = objectDesignator;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.refuseFurtherComments();
        this.catalogName = catalogName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.refuseFurtherComments();
        this.objectName = objectName;
    }

    public String getInternationalDes() {
        return this.internationalDesignator;
    }

    public void setInternationalDes(String internationalDes) {
        this.refuseFurtherComments();
        this.internationalDesignator = internationalDes;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.refuseFurtherComments();
        this.objectType = objectType;
    }

    public String getOperatorContactPosition() {
        return this.operatorContact;
    }

    public void setOperatorContactPosition(String opContact) {
        this.refuseFurtherComments();
        this.operatorContact = opContact;
    }

    public String getOperatorOrganization() {
        return this.operatorOrganization;
    }

    public void setOperatorOrganization(String operatorOrganization) {
        this.refuseFurtherComments();
        this.operatorOrganization = operatorOrganization;
    }

    public String getOperatorPhone() {
        return this.operatorPhone;
    }

    public void setOperatorPhone(String operatorPhone) {
        this.refuseFurtherComments();
        this.operatorPhone = operatorPhone;
    }

    public String getOperatorEmail() {
        return this.operatorEmail;
    }

    public void setOperatorEmail(String operatorEmail) {
        this.refuseFurtherComments();
        this.operatorEmail = operatorEmail;
    }

    public String getEphemName() {
        return this.ephemName;
    }

    public void setEphemName(String ephemName) {
        this.refuseFurtherComments();
        this.ephemName = ephemName;
    }

    public CovarianceMethod getCovarianceMethod() {
        return this.covarianceMethod;
    }

    public void setCovarianceMethod(CovarianceMethod covarianceMethod) {
        this.refuseFurtherComments();
        this.covarianceMethod = covarianceMethod;
    }

    public Maneuvrable getManeuverable() {
        return this.maneuverable;
    }

    public void setManeuverable(Maneuvrable maneuverable) {
        this.refuseFurtherComments();
        this.maneuverable = maneuverable;
    }

    public BodyFacade getOrbitCenter() {
        return this.orbitCenter;
    }

    public void setOrbitCenter(BodyFacade orbitCenter) {
        this.refuseFurtherComments();
        this.orbitCenter = orbitCenter;
    }

    public Frame getFrame() {
        if (this.orbitCenter == null || this.orbitCenter.getBody() == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_DATA_LOADED_FOR_CELESTIAL_BODY, "No Orbit center name");
        }
        if (this.refFrame == null) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_FRAME, "No reference frame");
        }
        if (this.refFrame.asFrame() == null) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_FRAME, this.refFrame.getName());
        }
        boolean isMci = this.refFrame.asCelestialBodyFrame() == CelestialBodyFrame.MCI;
        boolean isIcrf = this.refFrame.asCelestialBodyFrame() == CelestialBodyFrame.ICRF;
        boolean isSolarSystemBarycenter = "solar system barycenter".equals(this.orbitCenter.getBody().getName());
        if (!isMci && !isIcrf && "Earth".equals(this.orbitCenter.getBody().getName()) || isMci && "Mars".equals(this.orbitCenter.getBody().getName()) || isIcrf && isSolarSystemBarycenter) {
            return this.refFrame.asFrame();
        }
        return new ModifiedFrame(this.refFrame.asFrame(), this.refFrame.asCelestialBodyFrame(), this.orbitCenter.getBody(), this.orbitCenter.getName());
    }

    public FrameFacade getRefFrame() {
        return this.refFrame;
    }

    public void setRefFrame(FrameFacade refFrame) {
        this.refuseFurtherComments();
        this.refFrame = refFrame;
    }

    public String getGravityModel() {
        return this.gravityModel;
    }

    public int getGravityDegree() {
        return this.gravityDegree;
    }

    public int getGravityOrder() {
        return this.gravityOrder;
    }

    public void setGravityModel(String name, int degree, int order) {
        this.refuseFurtherComments();
        this.gravityModel = name;
        this.gravityDegree = degree;
        this.gravityOrder = order;
    }

    public String getAtmosphericModel() {
        return this.atmosphericModel;
    }

    public void setAtmosphericModel(String atmosphericModel) {
        this.refuseFurtherComments();
        this.atmosphericModel = atmosphericModel;
    }

    public List<BodyFacade> getNBodyPerturbations() {
        return this.nBodyPerturbations;
    }

    public void setNBodyPerturbations(List<BodyFacade> nBody) {
        this.refuseFurtherComments();
        this.nBodyPerturbations = nBody;
    }

    public YesNoUnknown getSolarRadiationPressure() {
        return this.isSolarRadPressure;
    }

    public void setSolarRadiationPressure(YesNoUnknown isSolRadPressure) {
        this.refuseFurtherComments();
        this.isSolarRadPressure = isSolRadPressure;
    }

    public YesNoUnknown getEarthTides() {
        return this.isEarthTides;
    }

    public void setEarthTides(YesNoUnknown EarthTides) {
        this.refuseFurtherComments();
        this.isEarthTides = EarthTides;
    }

    public YesNoUnknown getIntrackThrust() {
        return this.isIntrackThrustModeled;
    }

    public void setIntrackThrust(YesNoUnknown IntrackThrustModeled) {
        this.refuseFurtherComments();
        this.isIntrackThrustModeled = IntrackThrustModeled;
    }

    public String getCovarianceSource() {
        return this.covarianceSource;
    }

    public void setCovarianceSource(String covarianceSource) {
        this.refuseFurtherComments();
        this.covarianceSource = covarianceSource;
    }

    public AltCovarianceType getAltCovType() {
        return this.altCovType;
    }

    public void setAltCovType(AltCovarianceType altCovType) {
        this.refuseFurtherComments();
        this.altCovType = altCovType;
    }

    public FrameFacade getAltCovRefFrame() {
        return this.altCovRefFrame;
    }

    public void setAltCovRefFrame(FrameFacade altCovRefFrame) {
        this.refuseFurtherComments();
        if (this.getAltCovType() == null) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_MISSING_KEYWORD, new Object[]{CdmMetadataKey.ALT_COV_TYPE});
        }
        if (altCovRefFrame.asFrame() == null) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_FRAME, altCovRefFrame.getName());
        }
        if (altCovRefFrame.asCelestialBodyFrame() != CelestialBodyFrame.GCRF && altCovRefFrame.asCelestialBodyFrame() != CelestialBodyFrame.EME2000 && !altCovRefFrame.asCelestialBodyFrame().name().contains("ITRF")) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_FRAME, altCovRefFrame.getName());
        }
        this.altCovRefFrame = altCovRefFrame;
    }

    public String getOdmMsgLink() {
        return this.odmMsgLink;
    }

    public void setOdmMsgLink(String odmMsgLink) {
        this.refuseFurtherComments();
        this.odmMsgLink = odmMsgLink;
    }

    public String getAdmMsgLink() {
        return this.admMsgLink;
    }

    public void setAdmMsgLink(String admMsgLink) {
        this.refuseFurtherComments();
        this.admMsgLink = admMsgLink;
    }

    public YesNoUnknown getObsBeforeNextMessage() {
        return this.obsBeforeNextMessage;
    }

    public void setObsBeforeNextMessage(YesNoUnknown obsBeforeNextMessage) {
        this.refuseFurtherComments();
        this.obsBeforeNextMessage = obsBeforeNextMessage;
    }
}

