/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.cdm.Cdm;
import org.orekit.files.ccsds.ndm.cdm.CdmData;
import org.orekit.files.ccsds.ndm.cdm.CdmHeader;
import org.orekit.files.ccsds.ndm.cdm.CdmHeaderKey;
import org.orekit.files.ccsds.ndm.cdm.CdmMetadata;
import org.orekit.files.ccsds.ndm.cdm.CdmRelativeMetadata;
import org.orekit.files.ccsds.ndm.cdm.CdmSegment;
import org.orekit.files.ccsds.section.HeaderKey;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.files.ccsds.utils.generation.MessageWriter;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.UTCScale;

public abstract class CdmMessageWriter
implements MessageWriter<CdmHeader, CdmSegment, Cdm> {
    public static final String DEFAULT_ORIGINATOR = "OREKIT";
    private final String root;
    private final String formatVersionKey;
    private final double defaultVersion;
    private ContextBinding context;
    private TimeConverter timeConverter;
    private double version;
    private boolean isrelativemetadataWritten;

    public CdmMessageWriter(String root, String formatVersionKey, double defaultVersion, ContextBinding context) {
        this.root = root;
        this.defaultVersion = defaultVersion;
        this.formatVersionKey = formatVersionKey;
        this.version = defaultVersion;
        this.isrelativemetadataWritten = false;
        this.setContext(context);
    }

    public void setContext(ContextBinding context) {
        this.context = context;
        this.timeConverter = context.getTimeSystem().getConverter(context);
    }

    public ContextBinding getContext() {
        return this.context;
    }

    public TimeConverter getTimeConverter() {
        return this.timeConverter;
    }

    public double getDefaultVersion() {
        return this.defaultVersion;
    }

    @Override
    public void writeHeader(Generator generator, CdmHeader header) throws IOException {
        ZonedDateTime zdt = ZonedDateTime.now(ZoneOffset.UTC);
        UTCScale utc = this.context.getDataContext().getTimeScales().getUTC();
        AbsoluteDate date = new AbsoluteDate(zdt.getYear(), zdt.getMonthValue(), zdt.getDayOfMonth(), zdt.getHour(), zdt.getMinute(), (double)zdt.getSecond(), (TimeScale)utc);
        if (header != null) {
            if (!Double.isNaN(header.getFormatVersion())) {
                this.version = header.getFormatVersion();
            }
            if (header.getCreationDate() == null) {
                header.setCreationDate(date);
            }
            if (header.getOriginator() == null) {
                header.setOriginator(DEFAULT_ORIGINATOR);
            }
            header.validate(this.version);
        }
        generator.startMessage(this.root, this.formatVersionKey, this.version);
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(XmlStructureKey.header.name());
        }
        if (header != null) {
            generator.writeComments(header.getComments());
        }
        DateTimeComponents creationDate = (header == null ? date : header.getCreationDate()).getComponents(utc);
        DateComponents dc = creationDate.getDate();
        TimeComponents tc = creationDate.getTime();
        generator.writeEntry(HeaderKey.CREATION_DATE.name(), generator.dateToString(dc.getYear(), dc.getMonth(), dc.getDay(), tc.getHour(), tc.getMinute(), tc.getSecond()), null, true);
        generator.writeEntry(HeaderKey.ORIGINATOR.name(), header == null ? DEFAULT_ORIGINATOR : header.getOriginator(), null, true);
        if (header != null) {
            generator.writeEntry(CdmHeaderKey.MESSAGE_FOR.name(), header.getMessageFor(), null, false);
        }
        if (header != null) {
            generator.writeEntry(HeaderKey.MESSAGE_ID.name(), header.getMessageId(), null, false);
        }
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
        generator.newLine();
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(XmlStructureKey.body.name());
        }
    }

    @Override
    public void writeSegment(Generator generator, CdmSegment segment) throws IOException {
        ((CdmMetadata)segment.getMetadata()).validate(this.version);
        ((CdmData)segment.getData()).validate(this.version);
        if (!this.isrelativemetadataWritten) {
            this.writeRelativeMetadataContent(generator, this.version, ((CdmMetadata)segment.getMetadata()).getRelativeMetadata());
            this.isrelativemetadataWritten = true;
        }
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(XmlStructureKey.segment.name());
        }
        this.writeSegmentContent(generator, this.version, segment);
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
    }

    public abstract void writeRelativeMetadataContent(Generator var1, double var2, CdmRelativeMetadata var4) throws IOException;

    public abstract void writeSegmentContent(Generator var1, double var2, Segment<CdmMetadata, CdmData> var4) throws IOException;

    @Override
    public void writeFooter(Generator generator) throws IOException {
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
        generator.endMessage(this.root);
    }

    @Override
    public String getRoot() {
        return this.root;
    }

    @Override
    public String getFormatVersionKey() {
        return this.formatVersionKey;
    }

    @Override
    public double getVersion() {
        return this.version;
    }
}

