/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.ndm.cdm.CdmHeaderKey;
import org.orekit.files.ccsds.ndm.cdm.CdmParser;
import org.orekit.files.ccsds.section.HeaderKey;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.files.ccsds.utils.parsing.ProcessingState;

public class CdmHeaderProcessingState
implements ProcessingState {
    private final ContextBinding context = new ContextBinding(parser::getConventions, parser::isSimpleEOP, parser::getDataContext, parser::getParsedUnitsBehavior, () -> null, () -> TimeSystem.UTC, () -> 0.0, () -> 1.0);
    private final CdmParser parser;

    public CdmHeaderProcessingState(CdmParser parser) {
        this.parser = parser;
    }

    @Override
    public boolean processToken(ParseToken token) {
        this.parser.inHeader();
        if (Double.isNaN(this.parser.getHeader().getFormatVersion())) {
            if (this.parser.getFormatVersionKey() != null && this.parser.getFormatVersionKey().equals(token.getName()) && token.getType() == TokenType.ENTRY) {
                this.parser.getHeader().setFormatVersion(token.getContentAsDouble());
                return true;
            }
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_FILE_FORMAT, token.getFileName());
        }
        try {
            return token.getName() != null && HeaderKey.valueOf(token.getName()).process(token, this.context, this.parser.getHeader());
        }
        catch (IllegalArgumentException iaeH) {
            try {
                return CdmHeaderKey.valueOf(token.getName()).process(token, this.context, this.parser.getHeader());
            }
            catch (IllegalArgumentException iaeC) {
                return false;
            }
        }
    }
}

