/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.cdm.AdditionalParameters;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.utils.units.Unit;

public enum AdditionalParametersKey {
    COMMENT((token, context, container) -> token.getType() == TokenType.ENTRY ? container.addComment(token.getContentAsNormalizedString()) : true),
    AREA_PC((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setAreaPC)),
    AREA_PC_MIN((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setAreaPCMin)),
    AREA_PC_MAX((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setAreaPCMax)),
    AREA_DRG((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setAreaDRG)),
    AREA_SRP((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setAreaSRP)),
    OEB_PARENT_FRAME((token, context, container) -> token.processAsFrame(container::setOebParentFrame, context, true, true, false)),
    OEB_PARENT_FRAME_EPOCH((token, context, container) -> token.processAsDate(container::setOebParentFrameEpoch, context)),
    OEB_Q1((token, context, container) -> token.processAsIndexedDouble(1, Unit.ONE, context.getParsedUnitsBehavior(), container::setOebQ)),
    OEB_Q2((token, context, container) -> token.processAsIndexedDouble(2, Unit.ONE, context.getParsedUnitsBehavior(), container::setOebQ)),
    OEB_Q3((token, context, container) -> token.processAsIndexedDouble(3, Unit.ONE, context.getParsedUnitsBehavior(), container::setOebQ)),
    OEB_QC((token, context, container) -> token.processAsIndexedDouble(0, Unit.ONE, context.getParsedUnitsBehavior(), container::setOebQ)),
    OEB_MAX((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setOebMax)),
    OEB_INT((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setOebIntermediate)),
    OEB_MIN((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setOebMin)),
    AREA_ALONG_OEB_MAX((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setOebAreaAlongMax)),
    AREA_ALONG_OEB_INT((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setOebAreaAlongIntermediate)),
    AREA_ALONG_OEB_MIN((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setOebAreaAlongMin)),
    RCS((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setRcs)),
    RCS_MIN((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setMinRcs)),
    RCS_MAX((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setMaxRcs)),
    VM_ABSOLUTE((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setVmAbsolute)),
    VM_APPARENT_MIN((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setVmApparentMin)),
    VM_APPARENT((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setVmApparent)),
    VM_APPARENT_MAX((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setVmApparentMax)),
    REFLECTANCE((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setReflectance)),
    MASS((token, context, container) -> token.processAsDouble(Unit.KILOGRAM, context.getParsedUnitsBehavior(), container::setMass)),
    HBR((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setHbr)),
    CD_AREA_OVER_MASS((token, context, container) -> token.processAsDouble(Units.M2_PER_KG, context.getParsedUnitsBehavior(), container::setCDAreaOverMass)),
    CR_AREA_OVER_MASS((token, context, container) -> token.processAsDouble(Units.M2_PER_KG, context.getParsedUnitsBehavior(), container::setCRAreaOverMass)),
    THRUST_ACCELERATION((token, context, container) -> token.processAsDouble(Units.M_PER_S2, context.getParsedUnitsBehavior(), container::setThrustAcceleration)),
    SEDR((token, context, container) -> token.processAsDouble(Units.W_PER_KG, context.getParsedUnitsBehavior(), container::setSedr)),
    APOAPSIS_ALTITUDE((token, context, container) -> token.processAsDouble(Unit.KILOMETRE, context.getParsedUnitsBehavior(), container::setApoapsisAltitude)),
    PERIAPSIS_ALTITUDE((token, context, container) -> token.processAsDouble(Unit.KILOMETRE, context.getParsedUnitsBehavior(), container::setPeriapsisAltitude)),
    INCLINATION((token, context, container) -> token.processAsDouble(Unit.DEGREE, context.getParsedUnitsBehavior(), container::setInclination)),
    COV_CONFIDENCE((token, context, container) -> token.processAsDouble(Unit.NONE, context.getParsedUnitsBehavior(), container::setCovConfidence)),
    COV_CONFIDENCE_METHOD((token, context, container) -> token.processAsFreeTextString(container::setCovConfidenceMethod));

    private final transient TokenProcessor processor;

    private AdditionalParametersKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, AdditionalParameters container) {
        return this.processor.process(token, context, container);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, AdditionalParameters var3);
    }
}

