/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.CommonPhysicalProperties;
import org.orekit.files.ccsds.ndm.cdm.AdditionalParametersKey;

public class AdditionalParameters
extends CommonPhysicalProperties {
    private double areaPC = Double.NaN;
    private double areaPCMin;
    private double areaPCMax;
    private double areaDRG = Double.NaN;
    private double areaSRP = Double.NaN;
    private double hbr;
    private double mass = Double.NaN;
    private double cdAreaOverMass = Double.NaN;
    private double crAreaOverMass = Double.NaN;
    private double thrustAcceleration = Double.NaN;
    private double sedr = Double.NaN;
    private double apoapsisAltitude;
    private double periapsisAltitude;
    private double inclination;
    private double covConfidence;
    private String covConfidenceMethod;

    public AdditionalParameters() {
        this.hbr = Double.NaN;
        this.apoapsisAltitude = Double.NaN;
        this.periapsisAltitude = Double.NaN;
        this.inclination = Double.NaN;
        this.covConfidence = Double.NaN;
    }

    @Override
    public void validate(double version) {
        super.validate(version);
    }

    public double getAreaPC() {
        return this.areaPC;
    }

    public void setAreaPC(double areaPC) {
        this.refuseFurtherComments();
        this.areaPC = areaPC;
    }

    public double getAreaDRG() {
        return this.areaDRG;
    }

    public void setAreaDRG(double areaDRG) {
        this.refuseFurtherComments();
        this.areaDRG = areaDRG;
    }

    public double getAreaSRP() {
        return this.areaSRP;
    }

    public void setAreaSRP(double areaSRP) {
        this.refuseFurtherComments();
        this.areaSRP = areaSRP;
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.refuseFurtherComments();
        this.mass = mass;
    }

    public double getCDAreaOverMass() {
        return this.cdAreaOverMass;
    }

    public void setCDAreaOverMass(double CDAreaOverMass) {
        this.refuseFurtherComments();
        this.cdAreaOverMass = CDAreaOverMass;
    }

    public double getCRAreaOverMass() {
        return this.crAreaOverMass;
    }

    public void setCRAreaOverMass(double CRAreaOverMass) {
        this.refuseFurtherComments();
        this.crAreaOverMass = CRAreaOverMass;
    }

    public double getThrustAcceleration() {
        return this.thrustAcceleration;
    }

    public void setThrustAcceleration(double thrustAcceleration) {
        this.refuseFurtherComments();
        this.thrustAcceleration = thrustAcceleration;
    }

    public double getSedr() {
        return this.sedr;
    }

    public void setSedr(double SEDR) {
        this.refuseFurtherComments();
        this.sedr = SEDR;
    }

    public double getAreaPCMin() {
        return this.areaPCMin;
    }

    public void setAreaPCMin(double areaPCMin) {
        this.areaPCMin = areaPCMin;
    }

    public double getAreaPCMax() {
        return this.areaPCMax;
    }

    public void setAreaPCMax(double areaPCMax) {
        this.areaPCMax = areaPCMax;
    }

    public double getHbr() {
        return this.hbr;
    }

    public void setHbr(double hbr) {
        this.refuseFurtherComments();
        this.hbr = hbr;
    }

    public double getApoapsisAltitude() {
        return this.apoapsisAltitude;
    }

    public void setApoapsisAltitude(double apoapsisAltitude) {
        this.refuseFurtherComments();
        this.apoapsisAltitude = apoapsisAltitude;
    }

    public double getPeriapsisAltitude() {
        return this.periapsisAltitude;
    }

    public void setPeriapsisAltitude(double periapsisAltitude) {
        this.refuseFurtherComments();
        this.periapsisAltitude = periapsisAltitude;
    }

    public double getInclination() {
        return this.inclination;
    }

    public void setInclination(double inclination) {
        this.refuseFurtherComments();
        this.inclination = inclination;
    }

    public double getCovConfidence() {
        return this.covConfidence;
    }

    public void setCovConfidence(double covConfidence) {
        this.refuseFurtherComments();
        this.covConfidence = covConfidence;
    }

    public String getCovConfidenceMethod() {
        return this.covConfidenceMethod;
    }

    public void setCovConfidenceMethod(String covConfidenceMethod) {
        this.refuseFurtherComments();
        if (Double.isNaN(this.getCovConfidence())) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_MISSING_KEYWORD, new Object[]{AdditionalParametersKey.COV_CONFIDENCE});
        }
        this.covConfidenceMethod = covConfidenceMethod;
    }
}

