/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.adm.apm.SpinStabilized;
import org.orekit.files.ccsds.ndm.adm.apm.SpinStabilizedKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.units.Unit;

class SpinStabilizedWriter
extends AbstractWriter {
    private final double formatVersion;
    private final SpinStabilized spinStabilized;

    SpinStabilizedWriter(double formatVersion, String xmlTag, String kvnTag, SpinStabilized spinStabilized) {
        super(xmlTag, kvnTag);
        this.formatVersion = formatVersion;
        this.spinStabilized = spinStabilized;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.spinStabilized.getComments());
        if (this.formatVersion < 2.0) {
            generator.writeEntry(SpinStabilizedKey.SPIN_FRAME_A.name(), this.spinStabilized.getEndpoints().getFrameA().getName(), null, true);
            generator.writeEntry(SpinStabilizedKey.SPIN_FRAME_B.name(), this.spinStabilized.getEndpoints().getFrameB().getName(), null, true);
            generator.writeEntry(SpinStabilizedKey.SPIN_DIR.name(), this.spinStabilized.getEndpoints().isA2b() ? "A2B" : "B2A", null, true);
        } else {
            generator.writeEntry(SpinStabilizedKey.REF_FRAME_A.name(), this.spinStabilized.getEndpoints().getFrameA().getName(), null, true);
            generator.writeEntry(SpinStabilizedKey.REF_FRAME_B.name(), this.spinStabilized.getEndpoints().getFrameB().getName(), null, true);
        }
        generator.writeEntry(SpinStabilizedKey.SPIN_ALPHA.name(), this.spinStabilized.getSpinAlpha(), Unit.DEGREE, true);
        generator.writeEntry(SpinStabilizedKey.SPIN_DELTA.name(), this.spinStabilized.getSpinDelta(), Unit.DEGREE, true);
        generator.writeEntry(SpinStabilizedKey.SPIN_ANGLE.name(), this.spinStabilized.getSpinAngle(), Unit.DEGREE, true);
        generator.writeEntry(SpinStabilizedKey.SPIN_ANGLE_VEL.name(), this.spinStabilized.getSpinAngleVel(), Units.DEG_PER_S, true);
        if (this.spinStabilized.hasMomentum()) {
            generator.writeEntry(SpinStabilizedKey.MOMENTUM_ALPHA.name(), this.spinStabilized.getMomentumAlpha(), Unit.DEGREE, true);
            generator.writeEntry(SpinStabilizedKey.MOMENTUM_DELTA.name(), this.spinStabilized.getMomentumDelta(), Unit.DEGREE, true);
            generator.writeEntry(SpinStabilizedKey.NUTATION_VEL.name(), this.spinStabilized.getNutationVel(), Units.DEG_PER_S, true);
        } else if (this.spinStabilized.hasNutation()) {
            generator.writeEntry(SpinStabilizedKey.NUTATION.name(), this.spinStabilized.getNutation(), Unit.DEGREE, true);
            generator.writeEntry(SpinStabilizedKey.NUTATION_PER.name(), this.spinStabilized.getNutationPeriod(), Unit.SECOND, true);
            generator.writeEntry(SpinStabilizedKey.NUTATION_PHASE.name(), this.spinStabilized.getNutationPhase(), Unit.DEGREE, true);
        }
    }
}

