/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.adm.apm.Maneuver;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.utils.units.Unit;

public enum ManeuverKey {
    COMMENT((token, context, container) -> token.getType() == TokenType.ENTRY ? container.addComment(token.getContentAsNormalizedString()) : true),
    MAN_EPOCH_START((token, context, container) -> token.processAsDate(container::setEpochStart, context)),
    MAN_DURATION((token, context, container) -> token.processAsDouble(Unit.SECOND, context.getParsedUnitsBehavior(), container::setDuration)),
    MAN_REF_FRAME((token, context, container) -> token.processAsFrame(container::setFrame, context, true, true, true)),
    MAN_TOR_1((token, context, container) -> token.processAsIndexedDouble(0, Units.N_M, context.getParsedUnitsBehavior(), container::setTorque)),
    MAN_TOR_X((token, context, container) -> token.processAsIndexedDouble(0, Units.N_M, context.getParsedUnitsBehavior(), container::setTorque)),
    MAN_TOR_2((token, context, container) -> token.processAsIndexedDouble(1, Units.N_M, context.getParsedUnitsBehavior(), container::setTorque)),
    MAN_TOR_Y((token, context, container) -> token.processAsIndexedDouble(1, Units.N_M, context.getParsedUnitsBehavior(), container::setTorque)),
    MAN_TOR_3((token, context, container) -> token.processAsIndexedDouble(2, Units.N_M, context.getParsedUnitsBehavior(), container::setTorque)),
    MAN_TOR_Z((token, context, container) -> token.processAsIndexedDouble(2, Units.N_M, context.getParsedUnitsBehavior(), container::setTorque)),
    MAN_DELTA_MASS((token, context, container) -> token.processAsDouble(Unit.KILOGRAM, context.getParsedUnitsBehavior(), container::setDeltaMass));

    private final transient TokenProcessor processor;

    private ManeuverKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, Maneuver container) {
        return this.processor.process(token, context, container);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, Maneuver var3);
    }
}

