/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.util.Arrays;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.ndm.adm.apm.ManeuverKey;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.time.AbsoluteDate;

public class Maneuver
extends CommentsContainer {
    private AbsoluteDate epochStart;
    private FrameFacade frame;
    private double duration = Double.NaN;
    private double[] torque = new double[3];
    private double deltaMass = Double.NaN;

    public Maneuver() {
        Arrays.fill(this.torque, Double.NaN);
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkNotNull(this.epochStart, ManeuverKey.MAN_EPOCH_START.name());
        this.checkNotNaN(this.duration, ManeuverKey.MAN_DURATION.name());
        this.checkNotNull(this.frame, ManeuverKey.MAN_REF_FRAME.name());
        this.checkNotNaN(this.torque[0], ManeuverKey.MAN_TOR_1.name());
        this.checkNotNaN(this.torque[1], ManeuverKey.MAN_TOR_2.name());
        this.checkNotNaN(this.torque[2], ManeuverKey.MAN_TOR_3.name());
    }

    public AbsoluteDate getEpochStart() {
        return this.epochStart;
    }

    public void setEpochStart(AbsoluteDate epochStart) {
        this.refuseFurtherComments();
        this.epochStart = epochStart;
    }

    public FrameFacade getFrame() {
        return this.frame;
    }

    public void setFrame(FrameFacade frame) {
        this.refuseFurtherComments();
        this.frame = frame;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.refuseFurtherComments();
        this.duration = duration;
    }

    public Vector3D getTorque() {
        return new Vector3D(this.torque);
    }

    public void setTorque(int index, double value) {
        this.refuseFurtherComments();
        this.torque[index] = value;
    }

    public double getDeltaMass() {
        return this.deltaMass;
    }

    public void setDeltaMass(double deltaMass) {
        this.refuseFurtherComments();
        this.deltaMass = deltaMass;
    }
}

