/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.adm.apm.Inertia;
import org.orekit.files.ccsds.ndm.adm.apm.InertiaKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;

class InertiaWriter
extends AbstractWriter {
    private final double formatVersion;
    private final Inertia inertia;

    InertiaWriter(double formatVersion, String xmlTag, String kvnTag, Inertia spacecraftParameters) {
        super(xmlTag, kvnTag);
        this.formatVersion = formatVersion;
        this.inertia = spacecraftParameters;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.inertia.getComments());
        if (this.inertia.getFrame() != null) {
            generator.writeEntry(InertiaKey.INERTIA_REF_FRAME.name(), this.inertia.getFrame().getName(), null, false);
        }
        if (this.formatVersion < 2.0) {
            generator.writeEntry(InertiaKey.I11.name(), this.inertia.getInertiaMatrix().getEntry(0, 0), Units.KG_M2, true);
            generator.writeEntry(InertiaKey.I22.name(), this.inertia.getInertiaMatrix().getEntry(1, 1), Units.KG_M2, true);
            generator.writeEntry(InertiaKey.I33.name(), this.inertia.getInertiaMatrix().getEntry(2, 2), Units.KG_M2, true);
            generator.writeEntry(InertiaKey.I12.name(), this.inertia.getInertiaMatrix().getEntry(0, 1), Units.KG_M2, true);
            generator.writeEntry(InertiaKey.I13.name(), this.inertia.getInertiaMatrix().getEntry(0, 2), Units.KG_M2, true);
            generator.writeEntry(InertiaKey.I23.name(), this.inertia.getInertiaMatrix().getEntry(1, 2), Units.KG_M2, true);
        } else {
            generator.writeEntry(InertiaKey.IXX.name(), this.inertia.getInertiaMatrix().getEntry(0, 0), Units.KG_M2, true);
            generator.writeEntry(InertiaKey.IYY.name(), this.inertia.getInertiaMatrix().getEntry(1, 1), Units.KG_M2, true);
            generator.writeEntry(InertiaKey.IZZ.name(), this.inertia.getInertiaMatrix().getEntry(2, 2), Units.KG_M2, true);
            generator.writeEntry(InertiaKey.IXY.name(), this.inertia.getInertiaMatrix().getEntry(0, 1), Units.KG_M2, true);
            generator.writeEntry(InertiaKey.IXZ.name(), this.inertia.getInertiaMatrix().getEntry(0, 2), Units.KG_M2, true);
            generator.writeEntry(InertiaKey.IYZ.name(), this.inertia.getInertiaMatrix().getEntry(1, 2), Units.KG_M2, true);
        }
    }
}

