/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.ndm.CommonPhysicalProperties;
import org.orekit.files.ccsds.ndm.adm.apm.InertiaKey;

public class Inertia
extends CommonPhysicalProperties {
    private FrameFacade frame;
    private RealMatrix inertiaMatrix = MatrixUtils.createRealMatrix((double[][])new double[][]{{Double.NaN, Double.NaN, Double.NaN}, {Double.NaN, Double.NaN, Double.NaN}, {Double.NaN, Double.NaN, Double.NaN}});

    @Override
    public void validate(double version) {
        super.validate(version);
        if (version >= 2.0) {
            this.checkNotNull(this.frame, InertiaKey.INERTIA_REF_FRAME.name());
        }
        this.checkNotNaN(this.inertiaMatrix.getEntry(0, 0), InertiaKey.IXX.name());
        this.checkNotNaN(this.inertiaMatrix.getEntry(1, 1), InertiaKey.IYY.name());
        this.checkNotNaN(this.inertiaMatrix.getEntry(2, 2), InertiaKey.IZZ.name());
        this.checkNotNaN(this.inertiaMatrix.getEntry(0, 1), InertiaKey.IXY.name());
        this.checkNotNaN(this.inertiaMatrix.getEntry(0, 2), InertiaKey.IXZ.name());
        this.checkNotNaN(this.inertiaMatrix.getEntry(1, 2), InertiaKey.IYZ.name());
    }

    public void setFrame(FrameFacade frame) {
        this.frame = frame;
    }

    public FrameFacade getFrame() {
        return this.frame;
    }

    public RealMatrix getInertiaMatrix() {
        return this.inertiaMatrix;
    }

    public void setInertiaMatrixEntry(int j, int k, double entry) {
        this.refuseFurtherComments();
        this.inertiaMatrix.setEntry(j, k, entry);
        this.inertiaMatrix.setEntry(k, j, entry);
    }
}

