/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.adm.apm.Euler;
import org.orekit.files.ccsds.ndm.adm.apm.EulerKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.units.Unit;

class EulerWriter
extends AbstractWriter {
    private static String ANGLE = "_ANGLE";
    private static String RATE = "_RATE";
    private final double formatVersion;
    private final Euler euler;

    EulerWriter(double formatVersion, String xmlTag, String kvnTag, Euler euler) {
        super(xmlTag, kvnTag);
        this.formatVersion = formatVersion;
        this.euler = euler;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        boolean needsAngles;
        generator.writeComments(this.euler.getComments());
        if (this.formatVersion < 2.0) {
            generator.writeEntry(EulerKey.EULER_FRAME_A.name(), this.euler.getEndpoints().getFrameA().getName(), null, true);
            generator.writeEntry(EulerKey.EULER_FRAME_B.name(), this.euler.getEndpoints().getFrameB().getName(), null, true);
            generator.writeEntry(EulerKey.EULER_DIR.name(), this.euler.getEndpoints().isA2b() ? "A2B" : "B2A", null, true);
        } else {
            generator.writeEntry(EulerKey.REF_FRAME_A.name(), this.euler.getEndpoints().getFrameA().getName(), null, true);
            generator.writeEntry(EulerKey.REF_FRAME_B.name(), this.euler.getEndpoints().getFrameB().getName(), null, true);
        }
        String seq = this.euler.getEulerRotSeq().name();
        double[] angles = this.euler.getRotationAngles();
        if (this.formatVersion < 2.0) {
            generator.writeEntry(EulerKey.EULER_ROT_SEQ.name(), seq.replace('X', '1').replace('Y', '2').replace('Z', '3'), null, true);
            generator.writeEntry(EulerKey.RATE_FRAME.name(), this.euler.rateFrameIsA() ? EulerKey.EULER_FRAME_A.name() : EulerKey.EULER_FRAME_B.name(), null, this.euler.hasRates());
        } else {
            generator.writeEntry(EulerKey.EULER_ROT_SEQ.name(), seq, null, true);
        }
        boolean bl = needsAngles = !this.euler.hasRates();
        if (this.formatVersion < 2.0) {
            generator.writeEntry(seq.charAt(0) + ANGLE, angles[0], Unit.DEGREE, needsAngles);
            generator.writeEntry(seq.charAt(1) + ANGLE, angles[1], Unit.DEGREE, needsAngles);
            generator.writeEntry(seq.charAt(2) + ANGLE, angles[2], Unit.DEGREE, needsAngles);
        } else {
            generator.writeEntry(EulerKey.ANGLE_1.name(), angles[0], Unit.DEGREE, needsAngles);
            generator.writeEntry(EulerKey.ANGLE_2.name(), angles[1], Unit.DEGREE, needsAngles);
            generator.writeEntry(EulerKey.ANGLE_3.name(), angles[2], Unit.DEGREE, needsAngles);
        }
        if (this.euler.hasRates()) {
            double[] rates = this.euler.getRotationRates();
            if (this.formatVersion < 2.0) {
                generator.writeEntry(seq.charAt(0) + RATE, rates[0], Units.DEG_PER_S, true);
                generator.writeEntry(seq.charAt(1) + RATE, rates[1], Units.DEG_PER_S, true);
                generator.writeEntry(seq.charAt(2) + RATE, rates[2], Units.DEG_PER_S, true);
            } else {
                generator.writeEntry(EulerKey.ANGLE_1_DOT.name(), rates[0], Units.DEG_PER_S, true);
                generator.writeEntry(EulerKey.ANGLE_2_DOT.name(), rates[1], Units.DEG_PER_S, true);
                generator.writeEntry(EulerKey.ANGLE_3_DOT.name(), rates[2], Units.DEG_PER_S, true);
            }
        }
    }
}

