/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.util.Arrays;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.adm.AttitudeEndpoints;
import org.orekit.files.ccsds.ndm.adm.apm.EulerKey;
import org.orekit.files.ccsds.section.CommentsContainer;

public class Euler
extends CommentsContainer {
    private static final String KEY_ANGLES_V1 = "{X|Y|Z}_ANGLE";
    private static final String KEY_ANGLES_V2 = "ANGLE_{1|2|3}";
    private static final String KEY_RATES_V1 = "{X|Y|Z}_RATE";
    private static final String KEY_RATES_V2 = "ANGLE_{1|2|3}_DOT";
    private final AttitudeEndpoints endpoints = new AttitudeEndpoints();
    private RotationOrder eulerRotSeq;
    private Boolean rateFrameIsA;
    private double[] rotationAngles = new double[3];
    private double[] rotationRates = new double[3];
    private boolean inRotationAngles = false;

    public Euler() {
        Arrays.fill(this.rotationAngles, Double.NaN);
        Arrays.fill(this.rotationRates, Double.NaN);
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        if (version < 2.0) {
            this.endpoints.checkMandatoryEntriesExceptExternalFrame(version, EulerKey.EULER_FRAME_A, EulerKey.EULER_FRAME_B, EulerKey.EULER_DIR);
            this.endpoints.checkExternalFrame(EulerKey.EULER_FRAME_A, EulerKey.EULER_FRAME_B);
        } else {
            this.endpoints.checkMandatoryEntriesExceptExternalFrame(version, EulerKey.REF_FRAME_A, EulerKey.REF_FRAME_B, EulerKey.EULER_DIR);
            this.endpoints.checkExternalFrame(EulerKey.REF_FRAME_A, EulerKey.REF_FRAME_B);
        }
        this.checkNotNull(this.eulerRotSeq, EulerKey.EULER_ROT_SEQ.name());
        if (!this.hasAngles()) {
            for (double ra : this.rotationAngles) {
                if (Double.isNaN(ra)) continue;
                throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, version < 2.0 ? KEY_ANGLES_V1 : KEY_ANGLES_V2);
            }
        }
        if (!this.hasRates()) {
            for (double rr : this.rotationRates) {
                if (Double.isNaN(rr)) continue;
                throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, version < 2.0 ? KEY_RATES_V1 : KEY_RATES_V2);
            }
        }
        if (version < 2.0) {
            if (!this.hasAngles() && !this.hasRates()) {
                throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, "{X|Y|Z}_ANGLE/{X|Y|Z}_RATE");
            }
        } else if (!this.hasAngles()) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, KEY_ANGLES_V2);
        }
    }

    public AttitudeEndpoints getEndpoints() {
        return this.endpoints;
    }

    public RotationOrder getEulerRotSeq() {
        return this.eulerRotSeq;
    }

    public void setEulerRotSeq(RotationOrder eulerRotSeq) {
        this.refuseFurtherComments();
        this.eulerRotSeq = eulerRotSeq;
    }

    public boolean rateFrameIsA() {
        return this.rateFrameIsA == null ? false : this.rateFrameIsA;
    }

    public void setRateFrameIsA(boolean rateFrameIsA) {
        this.refuseFurtherComments();
        this.rateFrameIsA = rateFrameIsA;
    }

    public boolean isSpacecraftBodyRate() {
        return this.rateFrameIsA() ^ this.endpoints.getFrameA().asSpacecraftBodyFrame() == null;
    }

    public double[] getRotationAngles() {
        return (double[])this.rotationAngles.clone();
    }

    public void setLabeledRotationAngle(char axis, double angle) {
        if (this.eulerRotSeq != null) {
            for (int i = 0; i < this.rotationAngles.length; ++i) {
                if (this.eulerRotSeq.name().charAt(i) != axis || !Double.isNaN(this.rotationAngles[i])) continue;
                this.setIndexedRotationAngle(i, angle);
                return;
            }
        }
    }

    public void setIndexedRotationAngle(int axis, double angle) {
        this.refuseFurtherComments();
        this.rotationAngles[axis] = angle;
    }

    public double[] getRotationRates() {
        return (double[])this.rotationRates.clone();
    }

    public void setLabeledRotationRate(char axis, double rate) {
        if (this.eulerRotSeq != null) {
            for (int i = 0; i < this.rotationRates.length; ++i) {
                if (this.eulerRotSeq.name().charAt(i) != axis || !Double.isNaN(this.rotationRates[i])) continue;
                this.setIndexedRotationRate(i, rate);
                return;
            }
        }
    }

    public void setIndexedRotationRate(int axis, double rate) {
        this.refuseFurtherComments();
        this.rotationRates[axis] = rate;
    }

    boolean inRotationAngles() {
        return this.inRotationAngles;
    }

    public void setInRotationAngles(boolean inRotationAngles) {
        this.refuseFurtherComments();
        this.inRotationAngles = inRotationAngles;
    }

    public boolean hasAngles() {
        return !Double.isNaN(this.rotationAngles[0] + this.rotationAngles[1] + this.rotationAngles[2]);
    }

    public boolean hasRates() {
        return !Double.isNaN(this.rotationRates[0] + this.rotationRates[1] + this.rotationRates[2]);
    }
}

