/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.io.IOException;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.adm.AdmCommonMetadataWriter;
import org.orekit.files.ccsds.ndm.adm.AdmHeader;
import org.orekit.files.ccsds.ndm.adm.AdmMetadata;
import org.orekit.files.ccsds.ndm.adm.apm.AngularVelocityWriter;
import org.orekit.files.ccsds.ndm.adm.apm.Apm;
import org.orekit.files.ccsds.ndm.adm.apm.ApmData;
import org.orekit.files.ccsds.ndm.adm.apm.ApmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.adm.apm.ApmQuaternionWriter;
import org.orekit.files.ccsds.ndm.adm.apm.EulerWriter;
import org.orekit.files.ccsds.ndm.adm.apm.InertiaWriter;
import org.orekit.files.ccsds.ndm.adm.apm.Maneuver;
import org.orekit.files.ccsds.ndm.adm.apm.ManeuverWriter;
import org.orekit.files.ccsds.ndm.adm.apm.SpinStabilizedWriter;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.AbstractMessageWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class ApmWriter
extends AbstractMessageWriter<AdmHeader, Segment<AdmMetadata, ApmData>, Apm> {
    public static final double CCSDS_APM_VERS = 1.0;
    public static final int KVN_PADDING_WIDTH = 17;

    public ApmWriter(IERSConventions conventions, DataContext dataContext, AbsoluteDate missionReferenceDate) {
        super("apm", "CCSDS_APM_VERS", 1.0, new ContextBinding(() -> conventions, () -> false, () -> dataContext, () -> ParsedUnitsBehavior.STRICT_COMPLIANCE, () -> missionReferenceDate, () -> TimeSystem.UTC, () -> 0.0, () -> 1.0));
    }

    @Override
    protected void writeSegmentContent(Generator generator, double formatVersion, Segment<AdmMetadata, ApmData> segment) throws IOException {
        String kvnTag;
        String xmlTag;
        ContextBinding oldContext = this.getContext();
        AdmMetadata metadata = segment.getMetadata();
        this.setContext(new ContextBinding(oldContext::getConventions, oldContext::isSimpleEOP, oldContext::getDataContext, oldContext::getParsedUnitsBehavior, oldContext::getReferenceDate, metadata::getTimeSystem, oldContext::getClockCount, oldContext::getClockRate));
        new AdmCommonMetadataWriter(metadata).write(generator);
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(XmlStructureKey.data.name());
        }
        generator.writeComments(segment.getData().getComments());
        if (formatVersion >= 2.0) {
            generator.writeEntry("EPOCH", this.getTimeConverter(), segment.getData().getEpoch(), false, true);
        }
        if (segment.getData().getQuaternionBlock() != null) {
            xmlTag = ApmDataSubStructureKey.quaternionState.name();
            kvnTag = formatVersion < 2.0 ? null : ApmDataSubStructureKey.QUAT.name();
            new ApmQuaternionWriter(formatVersion, xmlTag, kvnTag, segment.getData().getQuaternionBlock(), formatVersion >= 2.0 ? null : segment.getData().getEpoch(), this.getTimeConverter()).write(generator);
        }
        if (segment.getData().getEulerBlock() != null) {
            xmlTag = formatVersion < 2.0 ? ApmDataSubStructureKey.eulerElementsThree.name() : ApmDataSubStructureKey.eulerAngleState.name();
            kvnTag = formatVersion < 2.0 ? null : ApmDataSubStructureKey.EULER.name();
            new EulerWriter(formatVersion, xmlTag, kvnTag, segment.getData().getEulerBlock()).write(generator);
        }
        if (segment.getData().getAngularVelocityBlock() != null) {
            xmlTag = ApmDataSubStructureKey.angularVelocity.name();
            kvnTag = ApmDataSubStructureKey.ANGVEL.name();
            new AngularVelocityWriter(xmlTag, kvnTag, segment.getData().getAngularVelocityBlock()).write(generator);
        }
        if (segment.getData().getSpinStabilizedBlock() != null) {
            if (formatVersion < 2.0) {
                xmlTag = ApmDataSubStructureKey.eulerElementsSpin.name();
                kvnTag = null;
            } else {
                xmlTag = ApmDataSubStructureKey.spin.name();
                kvnTag = ApmDataSubStructureKey.SPIN.name();
            }
            new SpinStabilizedWriter(formatVersion, xmlTag, kvnTag, segment.getData().getSpinStabilizedBlock()).write(generator);
        }
        if (segment.getData().getInertiaBlock() != null) {
            xmlTag = formatVersion < 2.0 ? ApmDataSubStructureKey.spacecraftParameters.name() : ApmDataSubStructureKey.inertia.name();
            kvnTag = formatVersion < 2.0 ? null : ApmDataSubStructureKey.INERTIA.name();
            new InertiaWriter(formatVersion, xmlTag, kvnTag, segment.getData().getInertiaBlock()).write(generator);
        }
        if (!segment.getData().getManeuvers().isEmpty()) {
            for (Maneuver maneuver : segment.getData().getManeuvers()) {
                String xmlTag2 = ApmDataSubStructureKey.maneuverParameters.name();
                String kvnTag2 = formatVersion < 2.0 ? null : ApmDataSubStructureKey.MAN.name();
                new ManeuverWriter(formatVersion, xmlTag2, kvnTag2, maneuver, this.getTimeConverter()).write(generator);
            }
        }
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
    }
}

