/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.io.IOException;
import org.hipparchus.complex.Quaternion;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.adm.apm.ApmQuaternion;
import org.orekit.files.ccsds.ndm.adm.apm.ApmQuaternionKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.units.Unit;

class ApmQuaternionWriter
extends AbstractWriter {
    private final double formatVersion;
    private final ApmQuaternion quaternion;
    private final AbsoluteDate epoch;
    private final TimeConverter timeConverter;

    ApmQuaternionWriter(double formatVersion, String xmlTag, String kvnTag, ApmQuaternion quaternion, AbsoluteDate epoch, TimeConverter timeConverter) {
        super(xmlTag, kvnTag);
        this.formatVersion = formatVersion;
        this.quaternion = quaternion;
        this.epoch = epoch;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.quaternion.getComments());
        if (this.epoch != null) {
            generator.writeEntry(ApmQuaternionKey.EPOCH.name(), this.timeConverter, this.epoch, false, true);
        }
        if (this.formatVersion < 2.0) {
            generator.writeEntry(ApmQuaternionKey.Q_FRAME_A.name(), this.quaternion.getEndpoints().getFrameA().getName(), null, true);
            generator.writeEntry(ApmQuaternionKey.Q_FRAME_B.name(), this.quaternion.getEndpoints().getFrameB().getName(), null, true);
            generator.writeEntry(ApmQuaternionKey.Q_DIR.name(), this.quaternion.getEndpoints().isA2b() ? "A2B" : "B2A", null, true);
        } else {
            generator.writeEntry(ApmQuaternionKey.REF_FRAME_A.name(), this.quaternion.getEndpoints().getFrameA().getName(), null, true);
            generator.writeEntry(ApmQuaternionKey.REF_FRAME_B.name(), this.quaternion.getEndpoints().getFrameB().getName(), null, true);
        }
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(ApmQuaternionKey.quaternion.name());
        }
        Quaternion q = this.quaternion.getQuaternion();
        generator.writeEntry(ApmQuaternionKey.Q1.name(), q.getQ1(), Unit.ONE, true);
        generator.writeEntry(ApmQuaternionKey.Q2.name(), q.getQ2(), Unit.ONE, true);
        generator.writeEntry(ApmQuaternionKey.Q3.name(), q.getQ3(), Unit.ONE, true);
        generator.writeEntry(ApmQuaternionKey.QC.name(), q.getQ0(), Unit.ONE, true);
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
        if (this.quaternion.hasRates()) {
            if (generator.getFormat() == FileFormat.XML) {
                generator.enterSection(this.formatVersion < 2.0 ? ApmQuaternionKey.quaternionRate.name() : ApmQuaternionKey.quaternionDot.name());
            }
            Quaternion qDot = this.quaternion.getQuaternionDot();
            generator.writeEntry(ApmQuaternionKey.Q1_DOT.name(), qDot.getQ1(), Unit.ONE, true);
            generator.writeEntry(ApmQuaternionKey.Q2_DOT.name(), qDot.getQ2(), Unit.ONE, true);
            generator.writeEntry(ApmQuaternionKey.Q3_DOT.name(), qDot.getQ3(), Unit.ONE, true);
            generator.writeEntry(ApmQuaternionKey.QC_DOT.name(), qDot.getQ0(), Unit.ONE, true);
            if (generator.getFormat() == FileFormat.XML) {
                generator.exitSection();
            }
        }
    }
}

