/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.util.Arrays;
import org.hipparchus.complex.Quaternion;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.adm.AttitudeEndpoints;
import org.orekit.files.ccsds.ndm.adm.apm.ApmQuaternionKey;
import org.orekit.files.ccsds.section.CommentsContainer;

public class ApmQuaternion
extends CommentsContainer {
    private final AttitudeEndpoints endpoints = new AttitudeEndpoints();
    private double[] q = new double[4];
    private double[] qDot = new double[4];

    public ApmQuaternion() {
        Arrays.fill(this.q, Double.NaN);
        Arrays.fill(this.qDot, Double.NaN);
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        if (version < 2.0) {
            this.endpoints.checkMandatoryEntriesExceptExternalFrame(version, ApmQuaternionKey.Q_FRAME_A, ApmQuaternionKey.Q_FRAME_B, ApmQuaternionKey.Q_DIR);
            this.endpoints.checkExternalFrame(ApmQuaternionKey.Q_FRAME_A, ApmQuaternionKey.Q_FRAME_B);
        } else {
            this.endpoints.checkMandatoryEntriesExceptExternalFrame(version, ApmQuaternionKey.REF_FRAME_A, ApmQuaternionKey.REF_FRAME_B, ApmQuaternionKey.Q_DIR);
            this.endpoints.checkExternalFrame(ApmQuaternionKey.REF_FRAME_A, ApmQuaternionKey.REF_FRAME_B);
        }
        if (Double.isNaN(this.q[0] + this.q[1] + this.q[2] + this.q[3])) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, "Q{C|1|2|3}");
        }
    }

    public AttitudeEndpoints getEndpoints() {
        return this.endpoints;
    }

    public Quaternion getQuaternion() {
        return new Quaternion(this.q[0], this.q[1], this.q[2], this.q[3]);
    }

    public void setQ(int index, double value) {
        this.refuseFurtherComments();
        this.q[index] = value;
    }

    public Quaternion getQuaternionDot() {
        return new Quaternion(this.qDot[0], this.qDot[1], this.qDot[2], this.qDot[3]);
    }

    public void setQDot(int index, double derivative) {
        this.refuseFurtherComments();
        this.qDot[index] = derivative;
    }

    public boolean hasRates() {
        return !Double.isNaN(this.qDot[0] + this.qDot[1] + this.qDot[2] + this.qDot[3]);
    }
}

