/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.adm.AdmCommonMetadataKey;
import org.orekit.files.ccsds.ndm.adm.AdmHeader;
import org.orekit.files.ccsds.ndm.adm.AdmMetadata;
import org.orekit.files.ccsds.ndm.adm.AdmMetadataKey;
import org.orekit.files.ccsds.ndm.adm.AdmParser;
import org.orekit.files.ccsds.ndm.adm.apm.AngularVelocity;
import org.orekit.files.ccsds.ndm.adm.apm.AngularVelocityKey;
import org.orekit.files.ccsds.ndm.adm.apm.Apm;
import org.orekit.files.ccsds.ndm.adm.apm.ApmData;
import org.orekit.files.ccsds.ndm.adm.apm.ApmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.adm.apm.ApmQuaternion;
import org.orekit.files.ccsds.ndm.adm.apm.ApmQuaternionKey;
import org.orekit.files.ccsds.ndm.adm.apm.Euler;
import org.orekit.files.ccsds.ndm.adm.apm.EulerKey;
import org.orekit.files.ccsds.ndm.adm.apm.Inertia;
import org.orekit.files.ccsds.ndm.adm.apm.InertiaKey;
import org.orekit.files.ccsds.ndm.adm.apm.Maneuver;
import org.orekit.files.ccsds.ndm.adm.apm.ManeuverKey;
import org.orekit.files.ccsds.ndm.adm.apm.SpinStabilized;
import org.orekit.files.ccsds.ndm.adm.apm.SpinStabilizedKey;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.files.ccsds.section.HeaderProcessingState;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureProcessingState;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.files.ccsds.utils.parsing.ErrorState;
import org.orekit.files.ccsds.utils.parsing.ProcessingState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class ApmParser
extends AdmParser<Apm, ApmParser> {
    private AdmHeader header;
    private List<Segment<AdmMetadata, ApmData>> segments;
    private AdmMetadata metadata;
    private ContextBinding context;
    private AbsoluteDate epoch;
    private CommentsContainer commentsBlock;
    private ApmQuaternion quaternionBlock;
    private Euler eulerBlock;
    private AngularVelocity angularVelocityBlock;
    private SpinStabilized spinStabilizedBlock;
    private Inertia inertiaBlock;
    private Maneuver currentManeuver;
    private List<Maneuver> maneuvers;
    private ProcessingState structureProcessor;

    public ApmParser(IERSConventions conventions, boolean simpleEOP, DataContext dataContext, AbsoluteDate missionReferenceDate, ParsedUnitsBehavior parsedUnitsBehavior, Function<ParseToken, List<ParseToken>>[] filters) {
        super("apm", "CCSDS_APM_VERS", conventions, simpleEOP, dataContext, missionReferenceDate, parsedUnitsBehavior, filters);
    }

    @Override
    public AdmHeader getHeader() {
        return this.header;
    }

    @Override
    public void reset(FileFormat fileFormat) {
        this.header = new AdmHeader();
        this.segments = new ArrayList<Segment<AdmMetadata, ApmData>>();
        this.metadata = null;
        this.context = null;
        this.quaternionBlock = null;
        this.eulerBlock = null;
        this.spinStabilizedBlock = null;
        this.inertiaBlock = null;
        this.currentManeuver = null;
        this.maneuvers = new ArrayList<Maneuver>();
        if (fileFormat == FileFormat.XML) {
            this.structureProcessor = new XmlStructureProcessingState("apm", this);
            this.reset(fileFormat, this.structureProcessor);
        } else {
            this.structureProcessor = new ErrorState();
            this.reset(fileFormat, new HeaderProcessingState(this));
        }
    }

    @Override
    public boolean prepareHeader() {
        this.anticipateNext(new HeaderProcessingState(this));
        return true;
    }

    @Override
    public boolean inHeader() {
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this.structureProcessor : this::processMetadataToken);
        return true;
    }

    @Override
    public boolean finalizeHeader() {
        this.header.validate(this.header.getFormatVersion());
        return true;
    }

    @Override
    public boolean prepareMetadata() {
        if (this.metadata != null) {
            return false;
        }
        this.metadata = new AdmMetadata();
        this.context = new ContextBinding(this::getConventions, this::isSimpleEOP, this::getDataContext, this::getParsedUnitsBehavior, this::getMissionReferenceDate, this.metadata::getTimeSystem, () -> 0.0, () -> 1.0);
        this.anticipateNext(this::processMetadataToken);
        return true;
    }

    @Override
    public boolean inMetadata() {
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this.structureProcessor : this::processDataToken);
        return true;
    }

    @Override
    public boolean finalizeMetadata() {
        this.metadata.validate(this.header.getFormatVersion());
        return true;
    }

    @Override
    public boolean prepareData() {
        this.commentsBlock = new CommentsContainer();
        this.anticipateNext(this.getFileFormat() == FileFormat.KVN && this.header.getFormatVersion() < 2.0 ? this::processDataToken : this::processDataSubStructureToken);
        return true;
    }

    @Override
    public boolean inData() {
        return true;
    }

    @Override
    public boolean finalizeData() {
        if (this.metadata != null) {
            ApmData data = new ApmData(this.commentsBlock, this.epoch, this.quaternionBlock, this.eulerBlock, this.angularVelocityBlock, this.spinStabilizedBlock, this.inertiaBlock);
            if (this.currentManeuver != null) {
                this.maneuvers.add(this.currentManeuver);
                this.currentManeuver = null;
            }
            for (Maneuver maneuver : this.maneuvers) {
                data.addManeuver(maneuver);
            }
            data.validate(this.header.getFormatVersion());
            this.segments.add(new Segment<AdmMetadata, ApmData>(this.metadata, data));
        }
        this.metadata = null;
        this.context = null;
        this.quaternionBlock = null;
        this.eulerBlock = null;
        this.angularVelocityBlock = null;
        this.spinStabilizedBlock = null;
        this.inertiaBlock = null;
        this.currentManeuver = null;
        return true;
    }

    @Override
    public Apm build() {
        this.finalizeData();
        Apm file = new Apm(this.header, this.segments, this.getConventions(), this.getDataContext());
        return file;
    }

    boolean addGeneralComment(String comment) {
        return this.commentsBlock.addComment(comment);
    }

    void setEpoch(AbsoluteDate epoch) {
        this.epoch = epoch;
    }

    boolean manageQuaternionSection(boolean starting) {
        this.anticipateNext(starting ? this::processQuaternionToken : this.structureProcessor);
        return true;
    }

    boolean manageEulerElementsSection(boolean starting) {
        this.anticipateNext(starting ? this::processEulerToken : this.structureProcessor);
        return true;
    }

    boolean manageAngularVelocitylementsSection(boolean starting) {
        this.anticipateNext(starting ? this::processAngularVelocityToken : this.structureProcessor);
        return true;
    }

    boolean manageSpinElementsSection(boolean starting) {
        this.anticipateNext(starting ? this::processSpinStabilizedToken : this.structureProcessor);
        return true;
    }

    boolean manageInertiaSection(boolean starting) {
        this.anticipateNext(starting ? this::processInertiaToken : this.structureProcessor);
        return true;
    }

    boolean manageManeuverParametersSection(boolean starting) {
        this.anticipateNext(starting ? this::processManeuverToken : this.structureProcessor);
        return true;
    }

    private boolean processMetadataToken(ParseToken token) {
        if (this.metadata == null) {
            this.prepareMetadata();
        }
        this.inMetadata();
        try {
            return token.getName() != null && MetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
        }
        catch (IllegalArgumentException iaeM) {
            try {
                return AdmMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
            }
            catch (IllegalArgumentException iaeD) {
                try {
                    return AdmCommonMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
                }
                catch (IllegalArgumentException iaeC) {
                    return false;
                }
            }
        }
    }

    private boolean processDataSubStructureToken(ParseToken token) {
        try {
            return token.getName() != null && ApmDataSubStructureKey.valueOf(token.getName()).process(token, this.context, this);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processDataToken(ParseToken token) {
        if (this.commentsBlock == null) {
            this.finalizeMetadata();
            this.prepareData();
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.KVN && this.header.getFormatVersion() < 2.0 ? this::processQuaternionToken : this::processDataSubStructureToken);
        if ("COMMENT".equals(token.getName())) {
            if (token.getType() == TokenType.ENTRY) {
                this.commentsBlock.addComment(token.getContentAsNormalizedString());
            }
            return true;
        }
        if ("EPOCH".equals(token.getName())) {
            if (token.getType() == TokenType.ENTRY) {
                token.processAsDate(date -> {
                    this.epoch = date;
                }, this.context);
            }
            return true;
        }
        return false;
    }

    private boolean processQuaternionToken(ParseToken token) {
        this.commentsBlock.refuseFurtherComments();
        if (this.quaternionBlock == null) {
            this.quaternionBlock = new ApmQuaternion();
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.KVN && this.header.getFormatVersion() < 2.0 ? this::processEulerToken : this::processDataSubStructureToken);
        try {
            return token.getName() != null && ApmQuaternionKey.valueOf(token.getName()).process(token, this.context, this.quaternionBlock, this::setEpoch);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processEulerToken(ParseToken token) {
        this.commentsBlock.refuseFurtherComments();
        if (this.eulerBlock == null) {
            this.eulerBlock = new Euler();
            if (this.moveCommentsIfEmpty(this.quaternionBlock, this.eulerBlock)) {
                this.quaternionBlock = null;
            }
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.KVN && this.header.getFormatVersion() < 2.0 ? this::processAngularVelocityToken : this::processDataSubStructureToken);
        try {
            return token.getName() != null && EulerKey.valueOf(token.getName()).process(token, this.context, this.eulerBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processAngularVelocityToken(ParseToken token) {
        this.commentsBlock.refuseFurtherComments();
        if (this.angularVelocityBlock == null) {
            this.angularVelocityBlock = new AngularVelocity();
            if (this.moveCommentsIfEmpty(this.eulerBlock, this.angularVelocityBlock)) {
                this.eulerBlock = null;
            }
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.KVN && this.header.getFormatVersion() < 2.0 ? this::processSpinStabilizedToken : this::processDataSubStructureToken);
        try {
            return token.getName() != null && AngularVelocityKey.valueOf(token.getName()).process(token, this.context, this.angularVelocityBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processSpinStabilizedToken(ParseToken token) {
        this.commentsBlock.refuseFurtherComments();
        if (this.spinStabilizedBlock == null) {
            this.spinStabilizedBlock = new SpinStabilized();
            if (this.moveCommentsIfEmpty(this.angularVelocityBlock, this.spinStabilizedBlock)) {
                this.angularVelocityBlock = null;
            }
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.KVN && this.header.getFormatVersion() < 2.0 ? this::processInertiaToken : this::processDataSubStructureToken);
        try {
            return token.getName() != null && SpinStabilizedKey.valueOf(token.getName()).process(token, this.context, this.spinStabilizedBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processInertiaToken(ParseToken token) {
        this.commentsBlock.refuseFurtherComments();
        if (this.inertiaBlock == null) {
            this.inertiaBlock = new Inertia();
            if (this.moveCommentsIfEmpty(this.spinStabilizedBlock, this.inertiaBlock)) {
                this.spinStabilizedBlock = null;
            }
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.KVN && this.header.getFormatVersion() < 2.0 ? this::processManeuverToken : this::processDataSubStructureToken);
        try {
            return token.getName() != null && InertiaKey.valueOf(token.getName()).process(token, this.context, this.inertiaBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processManeuverToken(ParseToken token) {
        this.commentsBlock.refuseFurtherComments();
        if (this.currentManeuver == null) {
            this.currentManeuver = new Maneuver();
            if (this.moveCommentsIfEmpty(this.inertiaBlock, this.currentManeuver)) {
                this.inertiaBlock = null;
            }
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.KVN && this.header.getFormatVersion() < 2.0 ? new ErrorState() : this::processDataSubStructureToken);
        try {
            return token.getName() != null && ManeuverKey.valueOf(token.getName()).process(token, this.context, this.currentManeuver);
        }
        catch (IllegalArgumentException iae) {
            this.maneuvers.add(this.currentManeuver);
            this.currentManeuver = null;
            return false;
        }
    }

    private boolean moveCommentsIfEmpty(CommentsContainer origin, CommentsContainer destination) {
        if (origin != null && origin.acceptComments()) {
            for (String comment : origin.getComments()) {
                destination.addComment(comment);
            }
            return true;
        }
        return false;
    }
}

