/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.complex.Quaternion;
import org.hipparchus.exception.Localizable;
import org.orekit.attitudes.Attitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.adm.AttitudeType;
import org.orekit.files.ccsds.ndm.adm.apm.AngularVelocity;
import org.orekit.files.ccsds.ndm.adm.apm.ApmQuaternion;
import org.orekit.files.ccsds.ndm.adm.apm.Euler;
import org.orekit.files.ccsds.ndm.adm.apm.Inertia;
import org.orekit.files.ccsds.ndm.adm.apm.Maneuver;
import org.orekit.files.ccsds.ndm.adm.apm.SpinStabilized;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.files.ccsds.section.Data;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class ApmData
implements Data {
    private final CommentsContainer commentsBlock;
    private final AbsoluteDate epoch;
    private final ApmQuaternion quaternionBlock;
    private final Euler eulerBlock;
    private final AngularVelocity angularVelocityBlock;
    private final SpinStabilized spinStabilizedBlock;
    private final Inertia inertia;
    private final List<Maneuver> maneuvers;

    public ApmData(CommentsContainer commentsBlock, AbsoluteDate epoch, ApmQuaternion quaternionBlock, Euler eulerBlock, AngularVelocity angularVelocityBlock, SpinStabilized spinStabilizedBlock, Inertia inertia) {
        this.commentsBlock = commentsBlock;
        this.epoch = epoch;
        this.quaternionBlock = quaternionBlock;
        this.eulerBlock = eulerBlock;
        this.angularVelocityBlock = angularVelocityBlock;
        this.spinStabilizedBlock = spinStabilizedBlock;
        this.inertia = inertia;
        this.maneuvers = new ArrayList<Maneuver>();
    }

    @Override
    public void validate(double version) {
        if (version < 2.0) {
            if (this.quaternionBlock == null) {
                new ApmQuaternion().validate(version);
            }
        } else if (this.quaternionBlock == null && this.eulerBlock == null && this.angularVelocityBlock == null && this.spinStabilizedBlock == null && this.inertia == null) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_INCOMPLETE_DATA, new Object[0]);
        }
        if (this.quaternionBlock != null) {
            this.quaternionBlock.validate(version);
        }
        if (this.eulerBlock != null) {
            this.eulerBlock.validate(version);
        }
        if (this.angularVelocityBlock != null) {
            this.angularVelocityBlock.validate(version);
        }
        if (this.spinStabilizedBlock != null) {
            this.spinStabilizedBlock.validate(version);
        }
        if (this.inertia != null) {
            this.inertia.validate(version);
        }
        for (Maneuver maneuver : this.maneuvers) {
            maneuver.validate(version);
        }
    }

    public List<String> getComments() {
        return this.commentsBlock.getComments();
    }

    public AbsoluteDate getEpoch() {
        return this.epoch;
    }

    public ApmQuaternion getQuaternionBlock() {
        return this.quaternionBlock;
    }

    public Euler getEulerBlock() {
        return this.eulerBlock;
    }

    public AngularVelocity getAngularVelocityBlock() {
        return this.angularVelocityBlock;
    }

    public SpinStabilized getSpinStabilizedBlock() {
        return this.spinStabilizedBlock;
    }

    public Inertia getInertiaBlock() {
        return this.inertia;
    }

    public int getNbManeuvers() {
        return this.maneuvers.size();
    }

    public List<Maneuver> getManeuvers() {
        return Collections.unmodifiableList(this.maneuvers);
    }

    public Maneuver getManeuver(int index) {
        return this.maneuvers.get(index);
    }

    public void addManeuver(Maneuver maneuver) {
        this.maneuvers.add(maneuver);
    }

    public boolean hasManeuvers() {
        return !this.maneuvers.isEmpty();
    }

    public Attitude getAttitude(Frame frame, PVCoordinatesProvider pvProvider) {
        if (this.quaternionBlock != null) {
            TimeStampedAngularCoordinates tac;
            Quaternion q = this.quaternionBlock.getQuaternion();
            if (this.quaternionBlock.hasRates()) {
                Quaternion qDot = this.quaternionBlock.getQuaternionDot();
                tac = AttitudeType.QUATERNION_DERIVATIVE.build(true, this.quaternionBlock.getEndpoints().isExternal2SpacecraftBody(), null, true, this.epoch, q.getQ0(), q.getQ1(), q.getQ2(), q.getQ3(), qDot.getQ0(), qDot.getQ1(), qDot.getQ2(), qDot.getQ3());
            } else if (this.angularVelocityBlock != null) {
                tac = AttitudeType.QUATERNION_ANGVEL.build(true, this.quaternionBlock.getEndpoints().isExternal2SpacecraftBody(), null, true, this.epoch, q.getQ0(), q.getQ1(), q.getQ2(), q.getQ3(), this.angularVelocityBlock.getAngVelX(), this.angularVelocityBlock.getAngVelY(), this.angularVelocityBlock.getAngVelZ());
            } else if (this.eulerBlock != null && this.eulerBlock.hasRates()) {
                double[] rates = this.eulerBlock.getRotationRates();
                if (this.eulerBlock.hasAngles()) {
                    double[] angles = this.eulerBlock.getRotationAngles();
                    tac = AttitudeType.EULER_ANGLE_DERIVATIVE.build(true, this.eulerBlock.getEndpoints().isExternal2SpacecraftBody(), this.eulerBlock.getEulerRotSeq(), this.eulerBlock.isSpacecraftBodyRate(), this.epoch, angles[0], angles[1], angles[2], rates[0], rates[1], rates[2]);
                } else {
                    tac = AttitudeType.QUATERNION_EULER_RATES.build(true, this.eulerBlock.getEndpoints().isExternal2SpacecraftBody(), this.eulerBlock.getEulerRotSeq(), this.eulerBlock.isSpacecraftBodyRate(), this.epoch, q.getQ0(), q.getQ1(), q.getQ2(), q.getQ3(), rates[0], rates[1], rates[2]);
                }
            } else {
                tac = AttitudeType.QUATERNION.build(true, this.quaternionBlock.getEndpoints().isExternal2SpacecraftBody(), null, true, this.epoch, q.getQ0(), q.getQ1(), q.getQ2(), q.getQ3());
            }
            return this.quaternionBlock.getEndpoints().build(frame, pvProvider, tac);
        }
        if (this.eulerBlock != null) {
            TimeStampedAngularCoordinates tac;
            double[] angles = this.eulerBlock.getRotationAngles();
            if (this.eulerBlock.hasRates()) {
                double[] rates = this.eulerBlock.getRotationRates();
                tac = AttitudeType.EULER_ANGLE_DERIVATIVE.build(true, this.eulerBlock.getEndpoints().isExternal2SpacecraftBody(), this.eulerBlock.getEulerRotSeq(), this.eulerBlock.isSpacecraftBodyRate(), this.epoch, angles[0], angles[1], angles[2], rates[0], rates[1], rates[2]);
            } else {
                tac = this.angularVelocityBlock != null ? AttitudeType.EULER_ANGLE_ANGVEL.build(true, this.eulerBlock.getEndpoints().isExternal2SpacecraftBody(), this.eulerBlock.getEulerRotSeq(), this.eulerBlock.isSpacecraftBodyRate(), this.epoch, angles[0], angles[1], angles[2], this.angularVelocityBlock.getAngVelX(), this.angularVelocityBlock.getAngVelY(), this.angularVelocityBlock.getAngVelZ()) : AttitudeType.EULER_ANGLE.build(true, this.eulerBlock.getEndpoints().isExternal2SpacecraftBody(), this.eulerBlock.getEulerRotSeq(), this.eulerBlock.isSpacecraftBodyRate(), this.epoch, angles[0], angles[1], angles[2]);
            }
            return this.eulerBlock.getEndpoints().build(frame, pvProvider, tac);
        }
        if (this.spinStabilizedBlock != null) {
            TimeStampedAngularCoordinates tac = this.spinStabilizedBlock.hasNutation() ? AttitudeType.SPIN_NUTATION.build(true, true, null, true, this.epoch, this.spinStabilizedBlock.getSpinAlpha(), this.spinStabilizedBlock.getSpinDelta(), this.spinStabilizedBlock.getSpinAngle(), this.spinStabilizedBlock.getSpinAngleVel(), this.spinStabilizedBlock.getNutation(), this.spinStabilizedBlock.getNutationPeriod(), this.spinStabilizedBlock.getNutationPhase()) : (this.spinStabilizedBlock.hasMomentum() ? AttitudeType.SPIN_NUTATION_MOMENTUM.build(true, true, null, true, this.epoch, this.spinStabilizedBlock.getSpinAlpha(), this.spinStabilizedBlock.getSpinDelta(), this.spinStabilizedBlock.getSpinAngle(), this.spinStabilizedBlock.getSpinAngleVel(), this.spinStabilizedBlock.getMomentumAlpha(), this.spinStabilizedBlock.getMomentumDelta(), this.spinStabilizedBlock.getNutationVel()) : AttitudeType.SPIN.build(true, true, null, true, this.epoch, this.spinStabilizedBlock.getSpinAlpha(), this.spinStabilizedBlock.getSpinDelta(), this.spinStabilizedBlock.getSpinAngle(), this.spinStabilizedBlock.getSpinAngleVel()));
            return this.spinStabilizedBlock.getEndpoints().build(frame, pvProvider, tac);
        }
        throw new OrekitException((Localizable)OrekitMessages.CCSDS_INCOMPLETE_DATA, new Object[0]);
    }
}

