/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.adm.apm.AngularVelocity;
import org.orekit.files.ccsds.ndm.adm.apm.AngularVelocityKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;

class AngularVelocityWriter
extends AbstractWriter {
    private final AngularVelocity angularVelocity;

    AngularVelocityWriter(String xmlTag, String kvnTag, AngularVelocity angularVelocity) {
        super(xmlTag, kvnTag);
        this.angularVelocity = angularVelocity;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.angularVelocity.getComments());
        generator.writeEntry(AngularVelocityKey.REF_FRAME_A.name(), this.angularVelocity.getEndpoints().getFrameA().getName(), null, true);
        generator.writeEntry(AngularVelocityKey.REF_FRAME_B.name(), this.angularVelocity.getEndpoints().getFrameB().getName(), null, true);
        generator.writeEntry(AngularVelocityKey.ANGVEL_FRAME.name(), this.angularVelocity.getFrame().getName(), null, true);
        generator.writeEntry(AngularVelocityKey.ANGVEL_X.name(), this.angularVelocity.getAngVelX(), Units.DEG_PER_S, true);
        generator.writeEntry(AngularVelocityKey.ANGVEL_Y.name(), this.angularVelocity.getAngVelY(), Units.DEG_PER_S, true);
        generator.writeEntry(AngularVelocityKey.ANGVEL_Z.name(), this.angularVelocity.getAngVelZ(), Units.DEG_PER_S, true);
    }
}

