/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.ndm.adm.AttitudeEndpoints;
import org.orekit.files.ccsds.ndm.adm.apm.AngularVelocityKey;
import org.orekit.files.ccsds.section.CommentsContainer;

public class AngularVelocity
extends CommentsContainer {
    private final AttitudeEndpoints endpoints = new AttitudeEndpoints();
    private FrameFacade frame = null;
    private double angVelX = Double.NaN;
    private double angVelY = Double.NaN;
    private double angVelZ = Double.NaN;

    @Override
    public void validate(double version) {
        super.validate(version);
        this.endpoints.checkMandatoryEntriesExceptExternalFrame(version, AngularVelocityKey.REF_FRAME_A, AngularVelocityKey.REF_FRAME_B, null);
        this.endpoints.checkExternalFrame(AngularVelocityKey.REF_FRAME_A, AngularVelocityKey.REF_FRAME_B);
        this.checkNotNull(this.frame, AngularVelocityKey.ANGVEL_FRAME.name());
        this.checkNotNaN(this.angVelX, AngularVelocityKey.ANGVEL_X.name());
        this.checkNotNaN(this.angVelY, AngularVelocityKey.ANGVEL_Y.name());
        this.checkNotNaN(this.angVelZ, AngularVelocityKey.ANGVEL_Z.name());
    }

    public AttitudeEndpoints getEndpoints() {
        return this.endpoints;
    }

    public void setFrame(FrameFacade frame) {
        this.frame = frame;
    }

    public FrameFacade getFrame() {
        return this.frame;
    }

    public double getAngVelX() {
        return this.angVelX;
    }

    public void setAngVelX(double angVelX) {
        this.refuseFurtherComments();
        this.angVelX = angVelX;
    }

    public double getAngVelY() {
        return this.angVelY;
    }

    public void setAngVelZ(double angVelZ) {
        this.refuseFurtherComments();
        this.angVelZ = angVelZ;
    }

    public double getAngVelZ() {
        return this.angVelZ;
    }

    public void setAngVelY(double angVelY) {
        this.refuseFurtherComments();
        this.angVelY = angVelY;
    }
}

