/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.aem;

import java.util.Arrays;
import org.orekit.files.ccsds.ndm.adm.AttitudeType;
import org.orekit.files.ccsds.ndm.adm.aem.AemMetadata;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedAngularCoordinates;

class AttitudeEntry {
    private final AemMetadata metadata;
    private AbsoluteDate epoch;
    private double[] components;

    AttitudeEntry(AemMetadata metadata) {
        this.metadata = metadata;
        this.components = new double[8];
        Arrays.fill(this.components, Double.NaN);
    }

    public AemMetadata getMetadata() {
        return this.metadata;
    }

    public void setEpoch(AbsoluteDate epoch) {
        this.epoch = epoch;
    }

    public void setComponent(int i, double value) {
        this.components[i] = value;
    }

    public void setLabeledAngle(char axis, double angle) {
        if (this.metadata.getEulerRotSeq() != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (this.metadata.getEulerRotSeq().name().charAt(i) != axis || !Double.isNaN(this.components[i])) continue;
                this.setComponent(i, angle);
                return;
            }
        }
    }

    public void setLabeledRate(char axis, double rate) {
        if (this.metadata.getEulerRotSeq() != null) {
            int first = this.metadata.getAttitudeType() == AttitudeType.QUATERNION_ANGVEL || this.metadata.getAttitudeType() == AttitudeType.QUATERNION_EULER_RATES ? 4 : 3;
            for (int i = 0; i < 3; ++i) {
                if (this.metadata.getEulerRotSeq().name().charAt(i) != axis || !Double.isNaN(this.components[first + i])) continue;
                this.setComponent(first + i, rate);
                return;
            }
        }
    }

    public TimeStampedAngularCoordinates getCoordinates() {
        return this.metadata.getAttitudeType().build(this.metadata.isFirst(), this.metadata.getEndpoints().isExternal2SpacecraftBody(), this.metadata.getEulerRotSeq(), this.metadata.isSpacecraftBodyRate(), this.epoch, this.components);
    }
}

