/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.aem;

import java.io.IOException;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitInternalError;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.adm.AdmCommonMetadataKey;
import org.orekit.files.ccsds.ndm.adm.AdmHeader;
import org.orekit.files.ccsds.ndm.adm.AdmMetadataKey;
import org.orekit.files.ccsds.ndm.adm.AttitudeType;
import org.orekit.files.ccsds.ndm.adm.aem.Aem;
import org.orekit.files.ccsds.ndm.adm.aem.AemData;
import org.orekit.files.ccsds.ndm.adm.aem.AemMetadata;
import org.orekit.files.ccsds.ndm.adm.aem.AemMetadataKey;
import org.orekit.files.ccsds.ndm.adm.aem.AemSegment;
import org.orekit.files.ccsds.ndm.adm.aem.AttitudeEntryKey;
import org.orekit.files.ccsds.ndm.adm.aem.XmlSubStructureKey;
import org.orekit.files.ccsds.section.KvnStructureKey;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.AbstractMessageWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.files.ccsds.utils.generation.XmlGenerator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.units.Unit;

public class AemWriter
extends AbstractMessageWriter<AdmHeader, AemSegment, Aem> {
    public static final double CCSDS_AEM_VERS = 2.0;
    public static final int KVN_PADDING_WIDTH = 20;
    private static final String A_TO_B = "A2B";
    private static final String B_TO_A = "B2A";
    private static final String FIRST = "FIRST";
    private static final String LAST = "LAST";
    private static final String REF_FRAME_A = "REF_FRAME_A";
    private static final String REF_FRAME_B = "REF_FRAME_B";
    private static final String ROTATION = "rotation";
    private static final String ANGLE_ATTRIBUTE = "angle";
    private static final String ANGLE_SUFFIX = "_ANGLE";
    private static final String RATE_ATTRIBUTE = "rate";
    private static final String RATE_SUFFIX = "_RATE";

    public AemWriter(IERSConventions conventions, DataContext dataContext, AbsoluteDate missionReferenceDate) {
        super("aem", "CCSDS_AEM_VERS", 2.0, new ContextBinding(() -> conventions, () -> true, () -> dataContext, () -> ParsedUnitsBehavior.STRICT_COMPLIANCE, () -> missionReferenceDate, () -> TimeSystem.UTC, () -> 0.0, () -> 1.0));
    }

    @Override
    protected void writeSegmentContent(Generator generator, double formatVersion, AemSegment segment) throws IOException {
        AemMetadata metadata = (AemMetadata)segment.getMetadata();
        this.writeMetadata(generator, formatVersion, metadata);
        this.startAttitudeBlock(generator);
        generator.writeComments(((AemData)segment.getData()).getComments());
        for (TimeStampedAngularCoordinates coordinates : segment.getAngularCoordinates()) {
            this.writeAttitudeEphemerisLine(generator, formatVersion, metadata, coordinates);
        }
        this.endAttitudeBlock(generator);
    }

    void writeMetadata(Generator generator, double formatVersion, AemMetadata metadata) throws IOException {
        ContextBinding oldContext = this.getContext();
        this.setContext(new ContextBinding(oldContext::getConventions, oldContext::isSimpleEOP, oldContext::getDataContext, oldContext::getParsedUnitsBehavior, oldContext::getReferenceDate, metadata::getTimeSystem, oldContext::getClockCount, oldContext::getClockRate));
        generator.enterSection(generator.getFormat() == FileFormat.KVN ? KvnStructureKey.META.name() : XmlStructureKey.metadata.name());
        generator.writeComments(metadata.getComments());
        generator.writeEntry(AdmMetadataKey.OBJECT_NAME.name(), metadata.getObjectName(), null, true);
        generator.writeEntry(AdmCommonMetadataKey.OBJECT_ID.name(), metadata.getObjectID(), null, true);
        if (metadata.getCenter() != null) {
            generator.writeEntry(AdmMetadataKey.CENTER_NAME.name(), metadata.getCenter().getName(), null, false);
        }
        generator.writeEntry(AemMetadataKey.REF_FRAME_A.name(), metadata.getEndpoints().getFrameA().getName(), null, true);
        generator.writeEntry(AemMetadataKey.REF_FRAME_B.name(), metadata.getEndpoints().getFrameB().getName(), null, true);
        if (formatVersion < 2.0) {
            generator.writeEntry(AemMetadataKey.ATTITUDE_DIR.name(), metadata.getEndpoints().isA2b() ? A_TO_B : B_TO_A, null, true);
        }
        generator.writeEntry(MetadataKey.TIME_SYSTEM.name(), metadata.getTimeSystem(), true);
        generator.writeEntry(AemMetadataKey.START_TIME.name(), this.getTimeConverter(), metadata.getStartTime(), false, true);
        if (metadata.getUseableStartTime() != null) {
            generator.writeEntry(AemMetadataKey.USEABLE_START_TIME.name(), this.getTimeConverter(), metadata.getUseableStartTime(), false, false);
        }
        if (metadata.getUseableStopTime() != null) {
            generator.writeEntry(AemMetadataKey.USEABLE_STOP_TIME.name(), this.getTimeConverter(), metadata.getUseableStopTime(), false, false);
        }
        generator.writeEntry(AemMetadataKey.STOP_TIME.name(), this.getTimeConverter(), metadata.getStopTime(), false, true);
        AttitudeType attitudeType = metadata.getAttitudeType();
        generator.writeEntry(AemMetadataKey.ATTITUDE_TYPE.name(), attitudeType.getName(formatVersion), null, true);
        if (formatVersion < 2.0 && (attitudeType == AttitudeType.QUATERNION || attitudeType == AttitudeType.QUATERNION_DERIVATIVE || attitudeType == AttitudeType.QUATERNION_ANGVEL)) {
            generator.writeEntry(AemMetadataKey.QUATERNION_TYPE.name(), metadata.isFirst() != false ? FIRST : LAST, null, false);
        }
        if (attitudeType == AttitudeType.QUATERNION_EULER_RATES || attitudeType == AttitudeType.EULER_ANGLE || attitudeType == AttitudeType.EULER_ANGLE_DERIVATIVE || attitudeType == AttitudeType.EULER_ANGLE_ANGVEL) {
            if (formatVersion < 2.0) {
                generator.writeEntry(AemMetadataKey.EULER_ROT_SEQ.name(), metadata.getEulerRotSeq().name().replace('X', '1').replace('Y', '2').replace('Z', '3'), null, false);
            } else {
                generator.writeEntry(AemMetadataKey.EULER_ROT_SEQ.name(), metadata.getEulerRotSeq().name(), null, false);
            }
        }
        if (formatVersion < 2.0 && attitudeType == AttitudeType.EULER_ANGLE_DERIVATIVE) {
            generator.writeEntry(AemMetadataKey.RATE_FRAME.name(), metadata.rateFrameIsA() ? REF_FRAME_A : REF_FRAME_B, null, false);
        }
        if (attitudeType == AttitudeType.QUATERNION_ANGVEL || attitudeType == AttitudeType.EULER_ANGLE_ANGVEL) {
            generator.writeEntry(AemMetadataKey.ANGVEL_FRAME.name(), metadata.getFrameAngvelFrame().getName(), null, true);
        }
        if (metadata.getInterpolationMethod() != null) {
            generator.writeEntry(AemMetadataKey.INTERPOLATION_METHOD.name(), metadata.getInterpolationMethod(), null, true);
            generator.writeEntry(AemMetadataKey.INTERPOLATION_DEGREE.name(), Integer.toString(metadata.getInterpolationDegree()), null, true);
        }
        generator.exitSection();
    }

    void writeAttitudeEphemerisLine(Generator generator, double formatVersion, AemMetadata metadata, TimeStampedAngularCoordinates attitude) throws IOException {
        String[] data = metadata.getAttitudeType().createDataFields(metadata.isFirst(), metadata.getEndpoints().isExternal2SpacecraftBody(), metadata.getEulerRotSeq(), metadata.isSpacecraftBodyRate(), attitude);
        if (generator.getFormat() == FileFormat.KVN) {
            generator.writeRawData(generator.dateToString(this.getTimeConverter(), attitude.getDate()));
            for (int index = 0; index < data.length; ++index) {
                generator.writeRawData(' ');
                generator.writeRawData(data[index]);
            }
            generator.newLine();
        } else {
            XmlGenerator xmlGenerator = (XmlGenerator)generator;
            xmlGenerator.enterSection(XmlSubStructureKey.attitudeState.name());
            switch (metadata.getAttitudeType()) {
                case QUATERNION: {
                    this.writeQuaternion(xmlGenerator, formatVersion, metadata.isFirst(), attitude.getDate(), data);
                    break;
                }
                case QUATERNION_DERIVATIVE: {
                    this.writeQuaternionDerivative(xmlGenerator, formatVersion, metadata.isFirst(), attitude.getDate(), data);
                    break;
                }
                case QUATERNION_EULER_RATES: {
                    this.writeQuaternionEulerRates(xmlGenerator, metadata.isFirst(), metadata.getEulerRotSeq(), attitude.getDate(), data);
                    break;
                }
                case QUATERNION_ANGVEL: {
                    this.writeQuaternionAngularVelocity(xmlGenerator, attitude.getDate(), data);
                    break;
                }
                case EULER_ANGLE: {
                    this.writeEulerAngle(xmlGenerator, formatVersion, metadata.getEulerRotSeq(), attitude.getDate(), data);
                    break;
                }
                case EULER_ANGLE_DERIVATIVE: {
                    this.writeEulerAngleDerivative(xmlGenerator, formatVersion, metadata.getEulerRotSeq(), attitude.getDate(), data);
                    break;
                }
                case EULER_ANGLE_ANGVEL: {
                    this.writeEulerAngleAngularVelocity(xmlGenerator, formatVersion, metadata.getEulerRotSeq(), attitude.getDate(), data);
                    break;
                }
                case SPIN: {
                    this.writeSpin(xmlGenerator, attitude.getDate(), data);
                    break;
                }
                case SPIN_NUTATION: {
                    this.writeSpinNutation(xmlGenerator, attitude.getDate(), data);
                    break;
                }
                case SPIN_NUTATION_MOMENTUM: {
                    this.writeSpinNutationMomentum(xmlGenerator, attitude.getDate(), data);
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            generator.exitSection();
        }
    }

    void writeQuaternion(XmlGenerator xmlGenerator, double formatVersion, boolean first, AbsoluteDate epoch, String[] data) throws IOException {
        xmlGenerator.enterSection(formatVersion < 2.0 ? AttitudeEntryKey.quaternionState.name() : AttitudeEntryKey.quaternionEphemeris.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.EPOCH.name(), this.getTimeConverter(), epoch, false, true);
        xmlGenerator.enterSection(AttitudeEntryKey.quaternion.name());
        int i = 0;
        if (formatVersion < 2.0 && first) {
            xmlGenerator.writeEntry(AttitudeEntryKey.QC.name(), data[i++], Unit.ONE, false);
        }
        xmlGenerator.writeEntry(AttitudeEntryKey.Q1.name(), data[i++], Unit.ONE, false);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q2.name(), data[i++], Unit.ONE, false);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q3.name(), data[i++], Unit.ONE, false);
        if (!(formatVersion < 2.0) || !first) {
            xmlGenerator.writeEntry(AttitudeEntryKey.QC.name(), data[i++], Unit.ONE, false);
        }
        xmlGenerator.exitSection();
        xmlGenerator.exitSection();
    }

    void writeQuaternionDerivative(XmlGenerator xmlGenerator, double formatVersion, boolean first, AbsoluteDate epoch, String[] data) throws IOException {
        xmlGenerator.enterSection(AttitudeEntryKey.quaternionDerivative.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.EPOCH.name(), this.getTimeConverter(), epoch, false, true);
        int i = 0;
        xmlGenerator.enterSection(AttitudeEntryKey.quaternion.name());
        if (formatVersion < 2.0 && first) {
            xmlGenerator.writeEntry(AttitudeEntryKey.QC.name(), data[i++], Unit.ONE, true);
        }
        xmlGenerator.writeEntry(AttitudeEntryKey.Q1.name(), data[i++], Unit.ONE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q2.name(), data[i++], Unit.ONE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q3.name(), data[i++], Unit.ONE, true);
        if (!(formatVersion < 2.0) || !first) {
            xmlGenerator.writeEntry(AttitudeEntryKey.QC.name(), data[i++], Unit.ONE, true);
        }
        xmlGenerator.exitSection();
        xmlGenerator.enterSection(formatVersion < 2.0 ? AttitudeEntryKey.quaternionRate.name() : AttitudeEntryKey.quaternionDot.name());
        if (formatVersion < 2.0 && first) {
            xmlGenerator.writeEntry(AttitudeEntryKey.QC_DOT.name(), data[i++], Units.ONE_PER_S, true);
        }
        xmlGenerator.writeEntry(AttitudeEntryKey.Q1_DOT.name(), data[i++], Units.ONE_PER_S, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q2_DOT.name(), data[i++], Units.ONE_PER_S, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q3_DOT.name(), data[i++], Units.ONE_PER_S, true);
        if (!(formatVersion < 2.0) || !first) {
            xmlGenerator.writeEntry(AttitudeEntryKey.QC_DOT.name(), data[i++], Units.ONE_PER_S, true);
        }
        xmlGenerator.exitSection();
        xmlGenerator.exitSection();
    }

    void writeQuaternionEulerRates(XmlGenerator xmlGenerator, boolean first, RotationOrder order, AbsoluteDate epoch, String[] data) throws IOException {
        xmlGenerator.enterSection(AttitudeEntryKey.quaternionEulerRate.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.EPOCH.name(), this.getTimeConverter(), epoch, false, true);
        int i = 0;
        xmlGenerator.enterSection(AttitudeEntryKey.quaternion.name());
        if (first) {
            xmlGenerator.writeEntry(AttitudeEntryKey.QC.name(), data[i++], Unit.ONE, true);
        }
        xmlGenerator.writeEntry(AttitudeEntryKey.Q1.name(), data[i++], Unit.ONE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q2.name(), data[i++], Unit.ONE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q3.name(), data[i++], Unit.ONE, true);
        if (!first) {
            xmlGenerator.writeEntry(AttitudeEntryKey.QC.name(), data[i++], Unit.ONE, true);
        }
        xmlGenerator.exitSection();
        xmlGenerator.enterSection(AttitudeEntryKey.rotationRates.name());
        this.writeLabeledEulerRate(xmlGenerator, 0, order.name(), data[i++]);
        this.writeLabeledEulerRate(xmlGenerator, 1, order.name(), data[i++]);
        this.writeLabeledEulerRate(xmlGenerator, 2, order.name(), data[i++]);
        xmlGenerator.exitSection();
        xmlGenerator.exitSection();
    }

    void writeQuaternionAngularVelocity(XmlGenerator xmlGenerator, AbsoluteDate epoch, String[] data) throws IOException {
        xmlGenerator.enterSection(AttitudeEntryKey.quaternionAngVel.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.EPOCH.name(), this.getTimeConverter(), epoch, false, true);
        int i = 0;
        xmlGenerator.enterSection(AttitudeEntryKey.quaternion.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.Q1.name(), data[i++], Unit.ONE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q2.name(), data[i++], Unit.ONE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q3.name(), data[i++], Unit.ONE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.QC.name(), data[i++], Unit.ONE, true);
        xmlGenerator.exitSection();
        xmlGenerator.enterSection(AttitudeEntryKey.angVel.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.ANGVEL_X.name(), data[i++], Units.DEG_PER_S, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.ANGVEL_Y.name(), data[i++], Units.DEG_PER_S, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.ANGVEL_Z.name(), data[i++], Units.DEG_PER_S, true);
        xmlGenerator.exitSection();
        xmlGenerator.exitSection();
    }

    void writeEulerAngle(XmlGenerator xmlGenerator, double formatVersion, RotationOrder order, AbsoluteDate epoch, String[] data) throws IOException {
        xmlGenerator.enterSection(AttitudeEntryKey.eulerAngle.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.EPOCH.name(), this.getTimeConverter(), epoch, false, true);
        int i = 0;
        if (formatVersion < 2.0) {
            xmlGenerator.enterSection(AttitudeEntryKey.rotationAngles.name());
            this.writeLabeledEulerAngle(xmlGenerator, 0, order.name(), data[i++]);
            this.writeLabeledEulerAngle(xmlGenerator, 1, order.name(), data[i++]);
            this.writeLabeledEulerAngle(xmlGenerator, 2, order.name(), data[i++]);
            xmlGenerator.exitSection();
        } else {
            xmlGenerator.writeEntry(AttitudeEntryKey.ANGLE_1.name(), data[i++], Unit.DEGREE, true);
            xmlGenerator.writeEntry(AttitudeEntryKey.ANGLE_2.name(), data[i++], Unit.DEGREE, true);
            xmlGenerator.writeEntry(AttitudeEntryKey.ANGLE_3.name(), data[i++], Unit.DEGREE, true);
        }
        xmlGenerator.exitSection();
    }

    void writeEulerAngleDerivative(XmlGenerator xmlGenerator, double formatVersion, RotationOrder order, AbsoluteDate epoch, String[] data) throws IOException {
        xmlGenerator.enterSection(formatVersion < 2.0 ? AttitudeEntryKey.eulerAngleRate.name() : AttitudeEntryKey.eulerAngleDerivative.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.EPOCH.name(), this.getTimeConverter(), epoch, false, true);
        int i = 0;
        if (formatVersion < 2.0) {
            xmlGenerator.enterSection(AttitudeEntryKey.rotationAngles.name());
            this.writeLabeledEulerAngle(xmlGenerator, 0, order.name(), data[i++]);
            this.writeLabeledEulerAngle(xmlGenerator, 1, order.name(), data[i++]);
            this.writeLabeledEulerAngle(xmlGenerator, 2, order.name(), data[i++]);
            xmlGenerator.exitSection();
            xmlGenerator.enterSection(AttitudeEntryKey.rotationRates.name());
            this.writeLabeledEulerRate(xmlGenerator, 0, order.name(), data[i++]);
            this.writeLabeledEulerRate(xmlGenerator, 1, order.name(), data[i++]);
            this.writeLabeledEulerRate(xmlGenerator, 2, order.name(), data[i++]);
            xmlGenerator.exitSection();
        } else {
            xmlGenerator.writeEntry(AttitudeEntryKey.ANGLE_1.name(), data[i++], Unit.DEGREE, true);
            xmlGenerator.writeEntry(AttitudeEntryKey.ANGLE_2.name(), data[i++], Unit.DEGREE, true);
            xmlGenerator.writeEntry(AttitudeEntryKey.ANGLE_3.name(), data[i++], Unit.DEGREE, true);
            xmlGenerator.writeEntry(AttitudeEntryKey.ANGLE_1_DOT.name(), data[i++], Units.DEG_PER_S, true);
            xmlGenerator.writeEntry(AttitudeEntryKey.ANGLE_2_DOT.name(), data[i++], Units.DEG_PER_S, true);
            xmlGenerator.writeEntry(AttitudeEntryKey.ANGLE_3_DOT.name(), data[i++], Units.DEG_PER_S, true);
        }
        xmlGenerator.exitSection();
    }

    void writeEulerAngleAngularVelocity(XmlGenerator xmlGenerator, double formatVersion, RotationOrder order, AbsoluteDate epoch, String[] data) throws IOException {
        xmlGenerator.enterSection(AttitudeEntryKey.eulerAngleAngVel.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.EPOCH.name(), this.getTimeConverter(), epoch, false, true);
        int i = 0;
        xmlGenerator.writeEntry(AttitudeEntryKey.ANGLE_1.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.ANGLE_2.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.ANGLE_3.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.ANGVEL_X.name(), data[i++], Units.DEG_PER_S, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.ANGVEL_Y.name(), data[i++], Units.DEG_PER_S, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.ANGVEL_Z.name(), data[i++], Units.DEG_PER_S, true);
        xmlGenerator.exitSection();
    }

    void writeSpin(XmlGenerator xmlGenerator, AbsoluteDate epoch, String[] data) throws IOException {
        xmlGenerator.enterSection(AttitudeEntryKey.spin.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.EPOCH.name(), this.getTimeConverter(), epoch, false, true);
        int i = 0;
        xmlGenerator.writeEntry(AttitudeEntryKey.SPIN_ALPHA.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.SPIN_DELTA.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.SPIN_ANGLE.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.SPIN_ANGLE_VEL.name(), data[i++], Units.DEG_PER_S, true);
        xmlGenerator.exitSection();
    }

    void writeSpinNutation(XmlGenerator xmlGenerator, AbsoluteDate epoch, String[] data) throws IOException {
        xmlGenerator.enterSection(AttitudeEntryKey.spinNutation.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.EPOCH.name(), this.getTimeConverter(), epoch, false, true);
        int i = 0;
        xmlGenerator.writeEntry(AttitudeEntryKey.SPIN_ALPHA.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.SPIN_DELTA.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.SPIN_ANGLE.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.SPIN_ANGLE_VEL.name(), data[i++], Units.DEG_PER_S, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.NUTATION.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.NUTATION_PER.name(), data[i++], Unit.SECOND, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.NUTATION_PHASE.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.exitSection();
    }

    void writeSpinNutationMomentum(XmlGenerator xmlGenerator, AbsoluteDate epoch, String[] data) throws IOException {
        xmlGenerator.enterSection(AttitudeEntryKey.spinNutationMom.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.EPOCH.name(), this.getTimeConverter(), epoch, false, true);
        int i = 0;
        xmlGenerator.writeEntry(AttitudeEntryKey.SPIN_ALPHA.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.SPIN_DELTA.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.SPIN_ANGLE.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.SPIN_ANGLE_VEL.name(), data[i++], Units.DEG_PER_S, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.MOMENTUM_ALPHA.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.MOMENTUM_DELTA.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.NUTATION_VEL.name(), data[i++], Units.DEG_PER_S, true);
        xmlGenerator.exitSection();
    }

    private void writeLabeledEulerAngle(XmlGenerator xmlGenerator, int index, String seq, String angle) throws IOException {
        if (xmlGenerator.writeUnits(Unit.DEGREE)) {
            xmlGenerator.writeTwoAttributesElement(ROTATION + (index + 1), angle, ANGLE_ATTRIBUTE, seq.charAt(index) + ANGLE_SUFFIX, "units", xmlGenerator.siToCcsdsName(Unit.DEGREE.getName()));
        } else {
            xmlGenerator.writeOneAttributeElement(ROTATION + (index + 1), angle, ANGLE_ATTRIBUTE, seq.charAt(index) + ANGLE_SUFFIX);
        }
    }

    private void writeLabeledEulerRate(XmlGenerator xmlGenerator, int index, String seq, String rate) throws IOException {
        if (xmlGenerator.writeUnits(Units.DEG_PER_S)) {
            xmlGenerator.writeTwoAttributesElement(ROTATION + (index + 1), rate, RATE_ATTRIBUTE, seq.charAt(index) + RATE_SUFFIX, "units", xmlGenerator.siToCcsdsName(Units.DEG_PER_S.getName()));
        } else {
            xmlGenerator.writeOneAttributeElement(ROTATION + (index + 1), rate, RATE_ATTRIBUTE, seq.charAt(index) + RATE_SUFFIX);
        }
    }

    void startAttitudeBlock(Generator generator) throws IOException {
        generator.enterSection(generator.getFormat() == FileFormat.KVN ? KvnStructureKey.DATA.name() : XmlStructureKey.data.name());
    }

    void endAttitudeBlock(Generator generator) throws IOException {
        generator.exitSection();
    }
}

