/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.aem;

import org.orekit.files.ccsds.ndm.adm.AttitudeType;
import org.orekit.files.ccsds.ndm.adm.aem.AemMetadata;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;

public enum AemMetadataKey {
    REF_FRAME_A((token, context, container) -> token.processAsFrame(container.getEndpoints()::setFrameA, context, true, true, true)),
    REF_FRAME_B((token, context, container) -> {
        if (token.getType() == TokenType.ENTRY) {
            container.checkNotNull(container.getEndpoints().getFrameA(), REF_FRAME_A.name());
            boolean aIsSpaceraftBody = container.getEndpoints().getFrameA().asSpacecraftBodyFrame() != null;
            return token.processAsFrame(container.getEndpoints()::setFrameB, context, aIsSpaceraftBody, aIsSpaceraftBody, !aIsSpaceraftBody);
        }
        return true;
    }),
    ATTITUDE_DIR((token, context, container) -> {
        if (token.getType() == TokenType.ENTRY) {
            container.getEndpoints().setA2b(token.getContentAsUppercaseCharacter() == 'A');
        }
        return true;
    }),
    START_TIME((token, context, container) -> token.processAsDate(container::setStartTime, context)),
    STOP_TIME((token, context, container) -> token.processAsDate(container::setStopTime, context)),
    USEABLE_START_TIME((token, context, container) -> token.processAsDate(container::setUseableStartTime, context)),
    USEABLE_STOP_TIME((token, context, container) -> token.processAsDate(container::setUseableStopTime, context)),
    ATTITUDE_TYPE((token, context, container) -> {
        if (token.getType() == TokenType.ENTRY) {
            try {
                container.setAttitudeType(AttitudeType.parseType(token.getRawContent()));
                return true;
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
        return true;
    }),
    QUATERNION_TYPE((token, context, container) -> {
        if (token.getType() == TokenType.ENTRY) {
            container.setIsFirst("FIRST".equals(token.getContentAsUppercaseString()));
        }
        return true;
    }),
    EULER_ROT_SEQ((token, context, container) -> token.processAsRotationOrder(container::setEulerRotSeq)),
    RATE_FRAME((token, context, container) -> {
        if (token.getType() == TokenType.ENTRY) {
            String content = token.getContentAsUppercaseString();
            char suffix = content.charAt(content.length() - 1);
            container.setRateFrameIsA(suffix == 'A');
        }
        return true;
    }),
    ANGVEL_FRAME((token, context, container) -> token.processAsFrame(container::setAngvelFrame, context, true, true, true)),
    INTERPOLATION_METHOD((token, context, container) -> token.processAsUppercaseString(container::setInterpolationMethod)),
    INTERPOLATION_DEGREE((token, context, container) -> token.processAsInteger(container::setInterpolationDegree));

    private final transient TokenProcessor processor;

    private AemMetadataKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, AemMetadata container) {
        return this.processor.process(token, context, container);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, AemMetadata var3);
    }
}

