/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.aem;

import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.ndm.adm.AdmMetadata;
import org.orekit.files.ccsds.ndm.adm.AttitudeEndpoints;
import org.orekit.files.ccsds.ndm.adm.AttitudeType;
import org.orekit.files.ccsds.ndm.adm.aem.AemMetadataKey;
import org.orekit.time.AbsoluteDate;

public class AemMetadata
extends AdmMetadata {
    private final AttitudeEndpoints endpoints = new AttitudeEndpoints();
    private AbsoluteDate startTime;
    private AbsoluteDate stopTime;
    private AbsoluteDate useableStartTime;
    private AbsoluteDate useableStopTime;
    private AttitudeType attitudeType;
    private Boolean isFirst;
    private RotationOrder eulerRotSeq;
    private Boolean rateFrameIsA;
    private FrameFacade angvelFrame;
    private String interpolationMethod;
    private int interpolationDegree;

    public AemMetadata(int defaultInterpolationDegree) {
        this.interpolationDegree = defaultInterpolationDegree;
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkMandatoryEntriesExceptDatesAndExternalFrame(version);
        this.endpoints.checkExternalFrame(AemMetadataKey.REF_FRAME_A, AemMetadataKey.REF_FRAME_B);
        this.checkNotNull(this.startTime, AemMetadataKey.START_TIME.name());
        this.checkNotNull(this.stopTime, AemMetadataKey.STOP_TIME.name());
        if (version >= 2.0 && this.isFirst().booleanValue()) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_KEYWORD_NOT_ALLOWED_IN_VERSION, new Object[]{AemMetadataKey.QUATERNION_TYPE, version});
        }
    }

    void checkMandatoryEntriesExceptDatesAndExternalFrame(double version) {
        super.validate(version);
        this.endpoints.checkMandatoryEntriesExceptExternalFrame(version, AemMetadataKey.REF_FRAME_A, AemMetadataKey.REF_FRAME_B, AemMetadataKey.ATTITUDE_DIR);
        this.checkNotNull((Object)this.attitudeType, AemMetadataKey.ATTITUDE_TYPE.name());
        if (version < 2.0) {
            if (this.attitudeType == AttitudeType.QUATERNION || this.attitudeType == AttitudeType.QUATERNION_DERIVATIVE) {
                this.checkNotNull(this.isFirst, AemMetadataKey.QUATERNION_TYPE.name());
            }
            if (this.attitudeType == AttitudeType.EULER_ANGLE_DERIVATIVE) {
                this.checkNotNull(this.rateFrameIsA, AemMetadataKey.RATE_FRAME.name());
            }
        } else if (this.attitudeType == AttitudeType.QUATERNION_ANGVEL) {
            this.checkNotNull(this.angvelFrame, AemMetadataKey.ANGVEL_FRAME.name());
        }
        if (this.attitudeType == AttitudeType.EULER_ANGLE || this.attitudeType == AttitudeType.EULER_ANGLE_DERIVATIVE) {
            this.checkNotNull(this.eulerRotSeq, AemMetadataKey.EULER_ROT_SEQ.name());
        }
    }

    public AttitudeEndpoints getEndpoints() {
        return this.endpoints;
    }

    public boolean rateFrameIsA() {
        return this.rateFrameIsA == null ? false : this.rateFrameIsA;
    }

    public void setRateFrameIsA(boolean rateFrameIsA) {
        this.refuseFurtherComments();
        this.rateFrameIsA = rateFrameIsA;
    }

    public void setAngvelFrame(FrameFacade angvelFrame) {
        this.angvelFrame = angvelFrame;
    }

    public FrameFacade getFrameAngvelFrame() {
        return this.angvelFrame;
    }

    public boolean isSpacecraftBodyRate() {
        return this.rateFrameIsA() ^ this.endpoints.getFrameA().asSpacecraftBodyFrame() == null;
    }

    public AttitudeType getAttitudeType() {
        return this.attitudeType;
    }

    public void setAttitudeType(AttitudeType type) {
        this.refuseFurtherComments();
        this.attitudeType = type;
    }

    public Boolean isFirst() {
        return this.isFirst == null ? Boolean.FALSE : this.isFirst;
    }

    public void setIsFirst(boolean isFirst) {
        this.refuseFurtherComments();
        this.isFirst = isFirst;
    }

    public RotationOrder getEulerRotSeq() {
        return this.eulerRotSeq;
    }

    public void setEulerRotSeq(RotationOrder eulerRotSeq) {
        this.refuseFurtherComments();
        this.eulerRotSeq = eulerRotSeq;
    }

    public AbsoluteDate getStartTime() {
        return this.startTime;
    }

    public void setStartTime(AbsoluteDate startTime) {
        this.refuseFurtherComments();
        this.startTime = startTime;
    }

    public AbsoluteDate getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(AbsoluteDate stopTime) {
        this.refuseFurtherComments();
        this.stopTime = stopTime;
    }

    public AbsoluteDate getUseableStartTime() {
        return this.useableStartTime;
    }

    public void setUseableStartTime(AbsoluteDate useableStartTime) {
        this.refuseFurtherComments();
        this.useableStartTime = useableStartTime;
    }

    public AbsoluteDate getUseableStopTime() {
        return this.useableStopTime;
    }

    public void setUseableStopTime(AbsoluteDate useableStopTime) {
        this.refuseFurtherComments();
        this.useableStopTime = useableStopTime;
    }

    public AbsoluteDate getStart() {
        AbsoluteDate start = this.getUseableStartTime();
        if (start != null) {
            return start;
        }
        return this.getStartTime();
    }

    public AbsoluteDate getStop() {
        AbsoluteDate stop = this.getUseableStopTime();
        if (stop != null) {
            return stop;
        }
        return this.getStopTime();
    }

    public String getInterpolationMethod() {
        return this.interpolationMethod;
    }

    public void setInterpolationMethod(String interpolationMethod) {
        this.refuseFurtherComments();
        this.interpolationMethod = interpolationMethod;
    }

    public int getInterpolationDegree() {
        return this.interpolationDegree;
    }

    public void setInterpolationDegree(int interpolationDegree) {
        this.refuseFurtherComments();
        this.interpolationDegree = interpolationDegree;
    }

    public int getInterpolationSamples() {
        return this.getInterpolationDegree() + 1;
    }

    AemMetadata copy(double version) {
        this.checkMandatoryEntriesExceptDatesAndExternalFrame(version);
        AemMetadata copy = new AemMetadata(this.getInterpolationDegree());
        for (String comment : this.getComments()) {
            copy.addComment(comment);
        }
        copy.setObjectName(this.getObjectName());
        copy.setObjectID(this.getObjectID());
        if (this.getCenter() != null) {
            copy.setCenter(this.getCenter());
        }
        copy.getEndpoints().setFrameA(this.getEndpoints().getFrameA());
        copy.getEndpoints().setFrameB(this.getEndpoints().getFrameB());
        copy.getEndpoints().setA2b(this.getEndpoints().isA2b());
        copy.setRateFrameIsA(this.rateFrameIsA());
        copy.setTimeSystem(this.getTimeSystem());
        copy.setAttitudeType(this.getAttitudeType());
        if (this.isFirst() != null) {
            copy.setIsFirst(this.isFirst());
        }
        if (this.getEulerRotSeq() != null) {
            copy.setEulerRotSeq(this.getEulerRotSeq());
        }
        if (this.getInterpolationMethod() != null) {
            copy.setInterpolationMethod(this.getInterpolationMethod());
        }
        return copy;
    }
}

