/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.aem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.NdmConstituent;
import org.orekit.files.ccsds.ndm.adm.AdmHeader;
import org.orekit.files.ccsds.ndm.adm.aem.AemMetadata;
import org.orekit.files.ccsds.ndm.adm.aem.AemSatelliteEphemeris;
import org.orekit.files.ccsds.ndm.adm.aem.AemSegment;
import org.orekit.files.general.AttitudeEphemerisFile;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class Aem
extends NdmConstituent<AdmHeader, AemSegment>
implements AttitudeEphemerisFile<TimeStampedAngularCoordinates, AemSegment> {
    public static final String ROOT = "aem";
    public static final String FORMAT_VERSION_KEY = "CCSDS_AEM_VERS";

    public Aem(AdmHeader header, List<AemSegment> segments, IERSConventions conventions, DataContext dataContext) {
        super(header, segments, conventions, dataContext);
    }

    @Override
    public Map<String, AemSatelliteEphemeris> getSatellites() {
        HashMap byId = new HashMap();
        for (AemSegment segment : this.getSegments()) {
            String id = ((AemMetadata)segment.getMetadata()).getObjectID();
            byId.putIfAbsent(id, new ArrayList());
            ((List)byId.get(id)).add(segment);
        }
        HashMap<String, AemSatelliteEphemeris> ret = new HashMap<String, AemSatelliteEphemeris>();
        for (Map.Entry entry : byId.entrySet()) {
            ret.put((String)entry.getKey(), new AemSatelliteEphemeris((String)entry.getKey(), (List)entry.getValue()));
        }
        return ret;
    }
}

