/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.UnivariateDerivative1;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.units.Unit;

public enum RateElementsType {
    ANGVEL("Angular velocity", new String[]{"\u00b0/s", "\u00b0/s", "\u00b0/s"}){

        @Override
        public TimeStampedAngularCoordinates toAngular(AbsoluteDate date, RotationOrder order, Rotation rotation, int first, double[] elements) {
            return new TimeStampedAngularCoordinates(date, rotation, new Vector3D(elements[first], elements[first + 1], elements[first + 2]), Vector3D.ZERO);
        }
    }
    ,
    Q_DOT("Quaternion derivatives", new String[]{"s\u207b\u00b9", "s\u207b\u00b9", "s\u207b\u00b9", "s\u207b\u00b9"}){

        @Override
        public TimeStampedAngularCoordinates toAngular(AbsoluteDate date, RotationOrder order, Rotation rotation, int first, double[] elements) {
            UnivariateDerivative1 q0 = new UnivariateDerivative1(rotation.getQ0(), elements[first + 3]);
            UnivariateDerivative1 q1 = new UnivariateDerivative1(rotation.getQ1(), elements[first]);
            UnivariateDerivative1 q2 = new UnivariateDerivative1(rotation.getQ2(), elements[first + 1]);
            UnivariateDerivative1 q3 = new UnivariateDerivative1(rotation.getQ3(), elements[first + 2]);
            return new TimeStampedAngularCoordinates(date, new FieldRotation((CalculusFieldElement)q0, (CalculusFieldElement)q1, (CalculusFieldElement)q2, (CalculusFieldElement)q3, false));
        }
    }
    ,
    EULER_RATE("Euler rates", new String[]{"\u00b0/s", "\u00b0/s", "\u00b0/s"}){

        @Override
        public TimeStampedAngularCoordinates toAngular(AbsoluteDate date, RotationOrder order, Rotation rotation, int first, double[] elements) {
            double[] euler0 = rotation.getAngles(order, RotationConvention.FRAME_TRANSFORM);
            UnivariateDerivative1 alpha0 = new UnivariateDerivative1(euler0[0], elements[first]);
            UnivariateDerivative1 alpha1 = new UnivariateDerivative1(euler0[1], elements[first + 1]);
            UnivariateDerivative1 alpha2 = new UnivariateDerivative1(euler0[2], elements[first + 2]);
            return new TimeStampedAngularCoordinates(date, new FieldRotation(order, RotationConvention.FRAME_TRANSFORM, (CalculusFieldElement)alpha0, (CalculusFieldElement)alpha1, (CalculusFieldElement)alpha2));
        }
    }
    ,
    GYRO_BIAS("Gyro rate corrections", new String[]{"\u00b0/s", "\u00b0/s", "\u00b0/s"}){

        @Override
        public TimeStampedAngularCoordinates toAngular(AbsoluteDate date, RotationOrder order, Rotation rotation, int first, double[] elements) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNSUPPORTED_ELEMENT_SET_TYPE, this.name(), this.toString());
        }
    }
    ,
    NONE("no rates", new String[0]){

        @Override
        public TimeStampedAngularCoordinates toAngular(AbsoluteDate date, RotationOrder order, Rotation rotation, int first, double[] elements) {
            return new TimeStampedAngularCoordinates(date, rotation, Vector3D.ZERO, Vector3D.ZERO);
        }
    };

    private final String description;
    private final List<Unit> units;

    private RateElementsType(String description, String ... unitsSpecifications) {
        this.description = description;
        this.units = Stream.of(unitsSpecifications).map(s -> Unit.parse(s)).collect(Collectors.toList());
    }

    public List<Unit> getUnits() {
        return this.units;
    }

    public abstract TimeStampedAngularCoordinates toAngular(AbsoluteDate var1, RotationOrder var2, Rotation var3, int var4, double[] var5);

    public String toString() {
        return this.description;
    }
}

