/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.adm.acm.AcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeElementsType;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeState;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeStateHistory;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeStateHistoryMetadata;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeStateHistoryMetadataKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.units.Unit;

class AttitudeStateHistoryWriter
extends AbstractWriter {
    private final AttitudeStateHistory history;
    private final TimeConverter timeConverter;

    AttitudeStateHistoryWriter(AttitudeStateHistory attitudeStateHistory, TimeConverter timeConverter) {
        super(AcmDataSubStructureKey.att.name(), AcmDataSubStructureKey.ATT.name());
        this.history = attitudeStateHistory;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        AttitudeStateHistoryMetadata metadata = this.history.getMetadata();
        generator.writeComments(metadata.getComments());
        generator.writeEntry(AttitudeStateHistoryMetadataKey.ATT_ID.name(), metadata.getAttID(), null, false);
        generator.writeEntry(AttitudeStateHistoryMetadataKey.ATT_PREV_ID.name(), metadata.getAttPrevID(), null, false);
        generator.writeEntry(AttitudeStateHistoryMetadataKey.ATT_BASIS.name(), metadata.getAttBasis(), null, false);
        generator.writeEntry(AttitudeStateHistoryMetadataKey.ATT_BASIS_ID.name(), metadata.getAttBasisID(), null, false);
        generator.writeEntry(AttitudeStateHistoryMetadataKey.REF_FRAME_A.name(), metadata.getEndpoints().getFrameA().getName(), null, true);
        generator.writeEntry(AttitudeStateHistoryMetadataKey.REF_FRAME_B.name(), metadata.getEndpoints().getFrameB().getName(), null, true);
        if (metadata.getAttitudeType() == AttitudeElementsType.EULER_ANGLES) {
            generator.writeEntry(AttitudeStateHistoryMetadataKey.EULER_ROT_SEQ.name(), (Enum<?>)metadata.getEulerRotSeq(), true);
        }
        generator.writeEntry(AttitudeStateHistoryMetadataKey.NUMBER_STATES.name(), metadata.getNbStates(), true);
        generator.writeEntry(AttitudeStateHistoryMetadataKey.ATT_TYPE.name(), metadata.getAttitudeType(), true);
        if (metadata.getRateType() != null) {
            generator.writeEntry(AttitudeStateHistoryMetadataKey.RATE_TYPE.name(), metadata.getRateType(), true);
        }
        List<Unit> attUnits = metadata.getAttitudeType().getUnits();
        List rateUnits = metadata.getRateType() == null ? Collections.emptyList() : metadata.getRateType().getUnits();
        for (AttitudeState state : this.history.getAttitudeStates()) {
            int i;
            double[] elements = state.getElements();
            StringBuilder line = new StringBuilder();
            line.append(generator.dateToString(this.timeConverter, state.getDate()));
            for (i = 0; i < attUnits.size(); ++i) {
                line.append(' ');
                line.append(AccurateFormatter.format(attUnits.get(i).fromSI(elements[i])));
            }
            for (i = 0; i < rateUnits.size(); ++i) {
                line.append(' ');
                line.append(AccurateFormatter.format(((Unit)rateUnits.get(i)).fromSI(elements[attUnits.size() + i])));
            }
            if (generator.getFormat() == FileFormat.XML) {
                generator.writeEntry("attLine", line.toString(), null, true);
                continue;
            }
            generator.writeRawData(line);
            generator.newLine();
        }
    }
}

