/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.adm.AttitudeEndpoints;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeElementsType;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeStateHistoryMetadataKey;
import org.orekit.files.ccsds.ndm.adm.acm.RateElementsType;
import org.orekit.files.ccsds.section.CommentsContainer;

public class AttitudeStateHistoryMetadata
extends CommentsContainer {
    private final AttitudeEndpoints endpoints = new AttitudeEndpoints();
    private String attID;
    private String attPrevID;
    private String attBasis;
    private String attBasisID;
    private RotationOrder eulerRotSeq;
    private int nbStates;
    private AttitudeElementsType attitudeType;
    private RateElementsType rateType;

    @Override
    public void validate(double version) {
        int rateSize;
        super.validate(version);
        this.endpoints.checkExternalFrame(AttitudeStateHistoryMetadataKey.REF_FRAME_A, AttitudeStateHistoryMetadataKey.REF_FRAME_B);
        this.checkNotNull((Object)this.attitudeType, AttitudeStateHistoryMetadataKey.ATT_TYPE.name());
        int n = rateSize = this.rateType == null ? 0 : this.rateType.getUnits().size();
        if (this.nbStates != this.attitudeType.getUnits().size() + rateSize) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_INCONSISTENT_NUMBER_OF_ATTITUDE_STATES, this.attitudeType.toString(), this.rateType.toString(), this.attitudeType.getUnits().size() + rateSize, this.nbStates);
        }
        if (this.attitudeType == AttitudeElementsType.EULER_ANGLES) {
            this.checkNotNull(this.eulerRotSeq, AttitudeStateHistoryMetadataKey.EULER_ROT_SEQ.name());
        }
    }

    public AttitudeEndpoints getEndpoints() {
        return this.endpoints;
    }

    public String getAttID() {
        return this.attID;
    }

    public void setAttID(String attID) {
        this.refuseFurtherComments();
        this.attID = attID;
    }

    public String getAttPrevID() {
        return this.attPrevID;
    }

    public void setAttPrevID(String attPrevID) {
        this.refuseFurtherComments();
        this.attPrevID = attPrevID;
    }

    public String getAttBasis() {
        return this.attBasis;
    }

    public void setAttBasis(String attBasis) {
        this.refuseFurtherComments();
        this.attBasis = attBasis;
    }

    public String getAttBasisID() {
        return this.attBasisID;
    }

    public void setAttBasisID(String attBasisID) {
        this.refuseFurtherComments();
        this.attBasisID = attBasisID;
    }

    public RotationOrder getEulerRotSeq() {
        return this.eulerRotSeq;
    }

    public void setEulerRotSeq(RotationOrder eulerRotSeq) {
        this.eulerRotSeq = eulerRotSeq;
    }

    public int getNbStates() {
        return this.nbStates;
    }

    public void setNbStates(int nbStates) {
        this.nbStates = nbStates;
    }

    public AttitudeElementsType getAttitudeType() {
        return this.attitudeType;
    }

    public void setAttitudeType(AttitudeElementsType attitudeType) {
        this.refuseFurtherComments();
        this.attitudeType = attitudeType;
    }

    public RateElementsType getRateType() {
        return this.rateType;
    }

    public void setRateType(RateElementsType rateType) {
        this.refuseFurtherComments();
        this.rateType = rateType;
    }
}

