/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.exception.Localizable;
import org.orekit.attitudes.BoundedAttitudeProvider;
import org.orekit.attitudes.TabulatedProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeState;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeStateHistoryMetadata;
import org.orekit.files.general.AttitudeEphemerisFile;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class AttitudeStateHistory
implements AttitudeEphemerisFile.AttitudeEphemerisSegment<TimeStampedAngularCoordinates> {
    private final AttitudeStateHistoryMetadata metadata;
    private final List<AttitudeState> states;

    public AttitudeStateHistory(AttitudeStateHistoryMetadata metadata, List<AttitudeState> states) {
        this.metadata = metadata;
        this.states = states;
    }

    public AttitudeStateHistoryMetadata getMetadata() {
        return this.metadata;
    }

    public List<AttitudeState> getAttitudeStates() {
        return Collections.unmodifiableList(this.states);
    }

    @Override
    public Frame getReferenceFrame() {
        Frame frame = this.metadata.getEndpoints().getFrameA().asFrame();
        if (frame == null) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_FRAME, this.metadata.getEndpoints().getFrameA().getName());
        }
        return frame;
    }

    @Override
    public int getInterpolationSamples() {
        return 1;
    }

    @Override
    public String getInterpolationMethod() {
        return "linear";
    }

    @Override
    public AngularDerivativesFilter getAvailableDerivatives() {
        return this.states.get(0).getAvailableDerivatives();
    }

    @Override
    public BoundedAttitudeProvider getAttitudeProvider() {
        return new TabulatedProvider(this.getAngularCoordinates(), this.getInterpolationSamples(), this.getAvailableDerivatives(), this.getStart(), this.getStop(), this.getMetadata().getEndpoints());
    }

    @Override
    public AbsoluteDate getStart() {
        return this.states.get(0).getDate();
    }

    @Override
    public AbsoluteDate getStop() {
        return this.states.get(this.states.size() - 1).getDate();
    }

    @Override
    public List<TimeStampedAngularCoordinates> getAngularCoordinates() {
        return this.states.stream().map(os -> os.toAngular(this.metadata.getEulerRotSeq())).collect(Collectors.toList());
    }
}

