/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.util.List;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeElementsType;
import org.orekit.files.ccsds.ndm.adm.acm.RateElementsType;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.units.Unit;

public class AttitudeState
implements TimeStamped {
    private final AttitudeElementsType attitudeType;
    private final RateElementsType rateType;
    private final AbsoluteDate date;
    private final double[] elements;

    public AttitudeState(AttitudeElementsType attitudeType, RateElementsType rateType, AbsoluteDate date, String[] fields, int first) {
        int i;
        this.attitudeType = attitudeType;
        this.rateType = rateType == null ? RateElementsType.NONE : rateType;
        List<Unit> attUnits = this.attitudeType.getUnits();
        List<Unit> rateUnits = this.rateType.getUnits();
        this.date = date;
        this.elements = new double[attUnits.size() + rateUnits.size()];
        for (i = 0; i < attUnits.size(); ++i) {
            this.elements[i] = attUnits.get(i).toSI(Double.parseDouble(fields[first + i]));
        }
        for (i = 0; i < rateUnits.size(); ++i) {
            this.elements[attUnits.size() + i] = rateUnits.get(i).toSI(Double.parseDouble(fields[attUnits.size() + first + i]));
        }
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    public double[] getElements() {
        return (double[])this.elements.clone();
    }

    public AttitudeElementsType getAttitudeType() {
        return this.attitudeType;
    }

    public RateElementsType getRateElementsType() {
        return this.rateType;
    }

    public AngularDerivativesFilter getAvailableDerivatives() {
        return this.rateType == RateElementsType.NONE ? AngularDerivativesFilter.USE_R : AngularDerivativesFilter.USE_RR;
    }

    public TimeStampedAngularCoordinates toAngular(RotationOrder order) {
        return this.rateType.toAngular(this.getDate(), order, this.attitudeType.toRotation(order, this.elements), this.attitudeType.getUnits().size(), this.elements);
    }
}

