/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.io.IOException;
import org.hipparchus.linear.RealMatrix;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.adm.acm.AcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudePhysicalProperties;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudePhysicalPropertiesKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.units.Unit;

class AttitudePhysicalPropertiesWriter
extends AbstractWriter {
    private final AttitudePhysicalProperties phys;

    AttitudePhysicalPropertiesWriter(AttitudePhysicalProperties phys) {
        super(AcmDataSubStructureKey.phys.name(), AcmDataSubStructureKey.PHYS.name());
        this.phys = phys;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        RealMatrix inertia;
        generator.writeComments(this.phys.getComments());
        generator.writeEntry(AttitudePhysicalPropertiesKey.DRAG_COEFF.name(), this.phys.getDragCoefficient(), Unit.ONE, false);
        generator.writeEntry(AttitudePhysicalPropertiesKey.WET_MASS.name(), this.phys.getWetMass(), Unit.KILOGRAM, false);
        generator.writeEntry(AttitudePhysicalPropertiesKey.DRY_MASS.name(), this.phys.getDryMass(), Unit.KILOGRAM, false);
        if (this.phys.getCenterOfPressureReferenceFrame() != null) {
            generator.writeEntry(AttitudePhysicalPropertiesKey.CP_REF_FRAME.name(), this.phys.getCenterOfPressureReferenceFrame().getName(), null, false);
        }
        if (this.phys.getCenterOfPressure() != null) {
            StringBuilder cp = new StringBuilder();
            cp.append(AccurateFormatter.format(Unit.METRE.fromSI(this.phys.getCenterOfPressure().getX())));
            cp.append(' ');
            cp.append(AccurateFormatter.format(Unit.METRE.fromSI(this.phys.getCenterOfPressure().getY())));
            cp.append(' ');
            cp.append(AccurateFormatter.format(Unit.METRE.fromSI(this.phys.getCenterOfPressure().getZ())));
            generator.writeEntry(AttitudePhysicalPropertiesKey.CP.name(), cp.toString(), Unit.METRE, false);
        }
        if (this.phys.getInertiaReferenceFrame() != null) {
            generator.writeEntry(AttitudePhysicalPropertiesKey.INERTIA_REF_FRAME.name(), this.phys.getInertiaReferenceFrame().getName(), null, false);
        }
        if ((inertia = this.phys.getInertiaMatrix()) != null) {
            generator.writeEntry(AttitudePhysicalPropertiesKey.IXX.name(), inertia.getEntry(0, 0), Units.KG_M2, true);
            generator.writeEntry(AttitudePhysicalPropertiesKey.IYY.name(), inertia.getEntry(1, 1), Units.KG_M2, true);
            generator.writeEntry(AttitudePhysicalPropertiesKey.IZZ.name(), inertia.getEntry(2, 2), Units.KG_M2, true);
            generator.writeEntry(AttitudePhysicalPropertiesKey.IXY.name(), inertia.getEntry(0, 1), Units.KG_M2, true);
            generator.writeEntry(AttitudePhysicalPropertiesKey.IXZ.name(), inertia.getEntry(0, 2), Units.KG_M2, true);
            generator.writeEntry(AttitudePhysicalPropertiesKey.IYZ.name(), inertia.getEntry(1, 2), Units.KG_M2, true);
        }
    }
}

