/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudePhysicalPropertiesKey;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.time.AbsoluteDate;

public class AttitudePhysicalProperties
extends CommentsContainer {
    private double dragCoefficient = Double.NaN;
    private double wetMass = Double.NaN;
    private double dryMass = Double.NaN;
    private FrameFacade centerOfPressureReferenceFrame;
    private Vector3D centerOfPressure;
    private FrameFacade inertiaReferenceFrame;
    private RealMatrix inertiaMatrix = MatrixUtils.createRealMatrix((int)3, (int)3);

    public AttitudePhysicalProperties(AbsoluteDate epochT0) {
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        if (this.centerOfPressureReferenceFrame != null) {
            this.checkNotNull(this.centerOfPressure, AttitudePhysicalPropertiesKey.CP.name());
        }
    }

    public double getDragCoefficient() {
        return this.dragCoefficient;
    }

    public void setDragCoefficient(double dragCoefficient) {
        this.refuseFurtherComments();
        this.dragCoefficient = dragCoefficient;
    }

    public double getWetMass() {
        return this.wetMass;
    }

    public void setWetMass(double wetMass) {
        this.refuseFurtherComments();
        this.wetMass = wetMass;
    }

    public double getDryMass() {
        return this.dryMass;
    }

    public void setDryMass(double dryMass) {
        this.refuseFurtherComments();
        this.dryMass = dryMass;
    }

    public FrameFacade getCenterOfPressureReferenceFrame() {
        return this.centerOfPressureReferenceFrame;
    }

    public void setCenterOfPressureReferenceFrame(FrameFacade centerOfPressureReferenceFrame) {
        this.centerOfPressureReferenceFrame = centerOfPressureReferenceFrame;
    }

    public Vector3D getCenterOfPressure() {
        return this.centerOfPressure;
    }

    public void setCenterOfPressure(Vector3D centerOfPressure) {
        this.centerOfPressure = centerOfPressure;
    }

    public FrameFacade getInertiaReferenceFrame() {
        return this.inertiaReferenceFrame;
    }

    public void setInertiaReferenceFrame(FrameFacade inertiaReferenceFrame) {
        this.inertiaReferenceFrame = inertiaReferenceFrame;
    }

    public RealMatrix getInertiaMatrix() {
        return this.inertiaMatrix;
    }

    public void setInertiaMatrixEntry(int j, int k, double entry) {
        this.refuseFurtherComments();
        this.inertiaMatrix.setEntry(j, k, entry);
        this.inertiaMatrix.setEntry(k, j, entry);
    }
}

