/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.adm.acm.AcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeManeuver;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeManeuverKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.units.Unit;

class AttitudeManeuverWriter
extends AbstractWriter {
    private final AttitudeManeuver man;

    AttitudeManeuverWriter(AttitudeManeuver attitudeManeuver) {
        super(AcmDataSubStructureKey.man.name(), AcmDataSubStructureKey.MAN.name());
        this.man = attitudeManeuver;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.man.getComments());
        generator.writeEntry(AttitudeManeuverKey.MAN_ID.name(), this.man.getID(), null, false);
        generator.writeEntry(AttitudeManeuverKey.MAN_PREV_ID.name(), this.man.getPrevID(), null, false);
        generator.writeEntry(AttitudeManeuverKey.MAN_PURPOSE.name(), this.man.getManPurpose(), null, true);
        generator.writeEntry(AttitudeManeuverKey.MAN_BEGIN_TIME.name(), this.man.getBeginTime(), Unit.SECOND, false);
        generator.writeEntry(AttitudeManeuverKey.MAN_END_TIME.name(), this.man.getEndTime(), Unit.SECOND, false);
        generator.writeEntry(AttitudeManeuverKey.MAN_DURATION.name(), this.man.getDuration(), Unit.SECOND, false);
        generator.writeEntry(AttitudeManeuverKey.ACTUATOR_USED.name(), this.man.getActuatorUsed(), null, false);
        if (this.man.getTargetMomentum() != null) {
            StringBuilder momentum = new StringBuilder();
            momentum.append(AccurateFormatter.format(Units.N_M_S.fromSI(this.man.getTargetMomentum().getX())));
            momentum.append(' ');
            momentum.append(AccurateFormatter.format(Units.N_M_S.fromSI(this.man.getTargetMomentum().getY())));
            momentum.append(' ');
            momentum.append(AccurateFormatter.format(Units.N_M_S.fromSI(this.man.getTargetMomentum().getZ())));
            generator.writeEntry(AttitudeManeuverKey.TARGET_MOMENTUM.name(), momentum.toString(), Units.N_M_S, true);
            if (this.man.getTargetMomFrame() != null) {
                generator.writeEntry(AttitudeManeuverKey.TARGET_MOM_FRAME.name(), this.man.getTargetMomFrame().getName(), null, false);
            }
        }
        if (this.man.getTargetAttitude() != null) {
            StringBuilder attitude = new StringBuilder();
            attitude.append(AccurateFormatter.format(this.man.getTargetAttitude().getQ1()));
            attitude.append(' ');
            attitude.append(AccurateFormatter.format(this.man.getTargetAttitude().getQ2()));
            attitude.append(' ');
            attitude.append(AccurateFormatter.format(this.man.getTargetAttitude().getQ3()));
            attitude.append(' ');
            attitude.append(AccurateFormatter.format(this.man.getTargetAttitude().getQ0()));
            generator.writeEntry(AttitudeManeuverKey.TARGET_ATTITUDE.name(), attitude.toString(), null, true);
        }
        generator.writeEntry(AttitudeManeuverKey.TARGET_SPINRATE.name(), this.man.getTargetSpinRate(), Units.DEG_PER_S, false);
    }
}

