/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeManeuver;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.utils.units.Unit;

public enum AttitudeManeuverKey {
    COMMENT((token, context, container) -> token.getType() == TokenType.ENTRY ? container.addComment(token.getContentAsNormalizedString()) : true),
    MAN_ID((token, context, container) -> token.processAsFreeTextString(container::setID)),
    MAN_PREV_ID((token, context, container) -> token.processAsFreeTextString(container::setPrevID)),
    MAN_PURPOSE((token, context, container) -> token.processAsFreeTextString(container::setManPurpose)),
    MAN_BEGIN_TIME((token, context, container) -> token.processAsDouble(Unit.SECOND, context.getParsedUnitsBehavior(), container::setBeginTime)),
    MAN_END_TIME((token, context, container) -> token.processAsDouble(Unit.SECOND, context.getParsedUnitsBehavior(), container::setEndTime)),
    MAN_DURATION((token, context, container) -> token.processAsDouble(Unit.SECOND, context.getParsedUnitsBehavior(), container::setDuration)),
    ACTUATOR_USED((token, context, container) -> token.processAsFreeTextString(container::setActuatorUsed)),
    TARGET_MOMENTUM((token, context, container) -> token.processAsVector(Units.N_M_S, context.getParsedUnitsBehavior(), container::setTargetMomentum)),
    TARGET_MOM_FRAME((token, context, container) -> token.processAsFrame(container::setTargetMomFrame, context, true, true, true)),
    TARGET_ATTITUDE((token, context, container) -> {
        block4: {
            try {
                if (token.getType() == TokenType.ENTRY) {
                    String[] fields = token.getRawContent().split("\\p{Space}+");
                    if (fields.length == 4) {
                        container.setTargetAttitude(new Rotation(Double.parseDouble(fields[3]), Double.parseDouble(fields[0]), Double.parseDouble(fields[1]), Double.parseDouble(fields[2]), true));
                        return true;
                    }
                    break block4;
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw token.generateException(null);
    }),
    TARGET_SPINRATE((token, context, container) -> token.processAsDouble(Units.DEG_PER_S, context.getParsedUnitsBehavior(), container::setTargetSpinRate));

    private final transient TokenProcessor processor;

    private AttitudeManeuverKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, AttitudeManeuver data) {
        return this.processor.process(token, context, data);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, AttitudeManeuver var3);
    }
}

