/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeManeuverKey;
import org.orekit.files.ccsds.section.CommentsContainer;

public class AttitudeManeuver
extends CommentsContainer {
    private String id;
    private String prevID;
    private String manPurpose;
    private double beginTime = Double.NaN;
    private double endTime = Double.NaN;
    private double duration = Double.NaN;
    private String actuatorUsed;
    private Vector3D targetMomentum;
    private FrameFacade targetMomFrame;
    private Rotation targetAttitude;
    private double targetSpinRate = Double.NaN;

    @Override
    public void validate(double version) {
        this.checkNotNull(this.manPurpose, AttitudeManeuverKey.MAN_PURPOSE.name());
        this.checkNotNaN(this.beginTime, AttitudeManeuverKey.MAN_BEGIN_TIME.name());
        if (!Double.isNaN(this.endTime + this.duration)) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_INCOMPATIBLE_KEYS_BOTH_USED, new Object[]{AttitudeManeuverKey.MAN_END_TIME, AttitudeManeuverKey.MAN_DURATION});
        }
        if (this.targetMomFrame != null) {
            this.checkNotNull(this.targetMomentum, AttitudeManeuverKey.TARGET_MOMENTUM.name());
        }
    }

    public String getID() {
        return this.id;
    }

    public void setID(String manId) {
        this.refuseFurtherComments();
        this.id = manId;
    }

    public String getPrevID() {
        return this.prevID;
    }

    public void setPrevID(String prevID) {
        this.refuseFurtherComments();
        this.prevID = prevID;
    }

    public String getManPurpose() {
        return this.manPurpose;
    }

    public void setManPurpose(String manPurpose) {
        this.refuseFurtherComments();
        this.manPurpose = manPurpose;
    }

    public double getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(double beginTime) {
        this.beginTime = beginTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void setEndTime(double endTime) {
        this.endTime = endTime;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public String getActuatorUsed() {
        return this.actuatorUsed;
    }

    public void setActuatorUsed(String actuatorUsed) {
        this.actuatorUsed = actuatorUsed;
    }

    public Vector3D getTargetMomentum() {
        return this.targetMomentum;
    }

    public void setTargetMomentum(Vector3D targetMomentum) {
        this.targetMomentum = targetMomentum;
    }

    public FrameFacade getTargetMomFrame() {
        return this.targetMomFrame;
    }

    public void setTargetMomFrame(FrameFacade targetMomFrame) {
        this.targetMomFrame = targetMomFrame;
    }

    public Rotation getTargetAttitude() {
        return this.targetAttitude;
    }

    public void setTargetAttitude(Rotation targetAttitude) {
        this.targetAttitude = targetAttitude;
    }

    public double getTargetSpinRate() {
        return this.targetSpinRate;
    }

    public void setTargetSpinRate(double targetSpinRate) {
        this.targetSpinRate = targetSpinRate;
    }
}

