/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.utils.units.Unit;

public enum AttitudeElementsType {
    QUATERNION("Quaternion", new String[]{"n/a", "n/a", "n/a", "n/a"}){

        @Override
        public Rotation toRotation(RotationOrder order, double[] elements) {
            return new Rotation(elements[3], elements[0], elements[1], elements[2], true);
        }
    }
    ,
    EULER_ANGLES("Euler angles", new String[]{"\u00b0", "\u00b0", "\u00b0"}){

        @Override
        public Rotation toRotation(RotationOrder order, double[] elements) {
            return new Rotation(order, RotationConvention.FRAME_TRANSFORM, elements[0], elements[1], elements[2]);
        }
    }
    ,
    DCM("Direction cosine matrix", new String[]{"n/a", "n/a", "n/a", "n/a", "n/a", "n/a", "n/a", "n/a", "n/a"}){

        @Override
        public Rotation toRotation(RotationOrder order, double[] elements) {
            return new Rotation((double[][])new double[][]{{elements[0], elements[3], elements[6]}, {elements[1], elements[4], elements[7]}, {elements[2], elements[5], elements[8]}}, 1.0E-10);
        }
    };

    private final String description;
    private final List<Unit> units;

    private AttitudeElementsType(String description, String ... unitsSpecifications) {
        this.description = description;
        this.units = Stream.of(unitsSpecifications).map(s -> Unit.parse(s)).collect(Collectors.toList());
    }

    public List<Unit> getUnits() {
        return this.units;
    }

    public abstract Rotation toRotation(RotationOrder var1, double[] var2);

    public String toString() {
        return this.description;
    }
}

