/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.adm.acm.AcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeDetermination;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeDeterminationKey;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeDeterminationSensor;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeDeterminationSensorKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.units.Unit;

class AttitudeDeterminationWriter
extends AbstractWriter {
    private final AttitudeDetermination ad;

    AttitudeDeterminationWriter(AttitudeDetermination attitudeDetermination) {
        super(AcmDataSubStructureKey.ad.name(), AcmDataSubStructureKey.AD.name());
        this.ad = attitudeDetermination;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.ad.getComments());
        generator.writeEntry(AttitudeDeterminationKey.AD_ID.name(), this.ad.getId(), null, false);
        generator.writeEntry(AttitudeDeterminationKey.AD_PREV_ID.name(), this.ad.getPrevId(), null, false);
        if (this.ad.getMethod() != null) {
            generator.writeEntry(AttitudeDeterminationKey.AD_METHOD.name(), this.ad.getMethod().name(), null, false);
        }
        generator.writeEntry(AttitudeDeterminationKey.ATTITUDE_SOURCE.name(), this.ad.getSource(), null, false);
        generator.writeEntry(AttitudeDeterminationKey.EULER_ROT_SEQ.name(), (Enum<?>)this.ad.getEulerRotSeq(), false);
        generator.writeEntry(AttitudeDeterminationKey.NUMBER_STATES.name(), this.ad.getNbStates(), false);
        generator.writeEntry(AttitudeDeterminationKey.ATTITUDE_STATES.name(), this.ad.getAttitudeStates(), true);
        generator.writeEntry(AttitudeDeterminationKey.COV_TYPE.name(), this.ad.getCovarianceType(), false);
        generator.writeEntry(AttitudeDeterminationKey.REF_FRAME_A.name(), this.ad.getEndpoints().getFrameA().getName(), null, false);
        generator.writeEntry(AttitudeDeterminationKey.REF_FRAME_B.name(), this.ad.getEndpoints().getFrameB().getName(), null, false);
        generator.writeEntry(AttitudeDeterminationKey.RATE_STATES.name(), this.ad.getRateStates(), false);
        generator.writeEntry(AttitudeDeterminationKey.SIGMA_U.name(), this.ad.getSigmaU(), Units.DEG_PER_S_3_2, false);
        generator.writeEntry(AttitudeDeterminationKey.SIGMA_V.name(), this.ad.getSigmaV(), Units.DEG_PER_S_1_2, false);
        generator.writeEntry(AttitudeDeterminationKey.RATE_PROCESS_NOISE_STDDEV.name(), this.ad.getRateProcessNoiseStdDev(), Units.DEG_PER_S_3_2, false);
        for (AttitudeDeterminationSensor sensor : this.ad.getSensorsUsed()) {
            generator.enterSection(AttitudeDeterminationKey.SENSOR.name());
            generator.writeEntry(AttitudeDeterminationSensorKey.SENSOR_NUMBER.name(), sensor.getSensorNumber(), true);
            generator.writeEntry(AttitudeDeterminationSensorKey.SENSOR_USED.name(), sensor.getSensorUsed(), null, true);
            double[] stddevDouble = sensor.getSensorNoiseCovariance();
            if (stddevDouble != null) {
                generator.writeEntry(AttitudeDeterminationSensorKey.NUMBER_SENSOR_NOISE_COVARIANCE.name(), stddevDouble.length, true);
                StringBuilder stddev = new StringBuilder();
                for (int k = 0; k < stddevDouble.length; ++k) {
                    if (k > 0) {
                        stddev.append(' ');
                    }
                    stddev.append(AccurateFormatter.format(Unit.DEGREE.fromSI(stddevDouble[k])));
                }
                generator.writeEntry(AttitudeDeterminationSensorKey.SENSOR_NOISE_STDDEV.name(), stddev.toString(), Unit.DEGREE, false);
            }
            generator.writeEntry(AttitudeDeterminationSensorKey.SENSOR_FREQUENCY.name(), sensor.getSensorFrequency(), Unit.HERTZ, false);
            generator.exitSection();
        }
    }
}

