/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.acm;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.adm.acm.AttitudeDeterminationSensorKey;
import org.orekit.files.ccsds.section.CommentsContainer;

public class AttitudeDeterminationSensor
extends CommentsContainer {
    private int sensorNumber;
    private String sensorUsed;
    private int nbSensorNoiseCovariance = -1;
    private double[] sensorNoiseCovariance;
    private double sensorFrequency = Double.NaN;

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkNotNegative(this.sensorNumber, AttitudeDeterminationSensorKey.SENSOR_NUMBER.name());
        this.checkNotNull(this.sensorUsed, AttitudeDeterminationSensorKey.SENSOR_USED.name());
        if (this.nbSensorNoiseCovariance >= 0) {
            int n;
            int n2 = n = this.sensorNoiseCovariance == null ? 0 : this.sensorNoiseCovariance.length;
            if (this.nbSensorNoiseCovariance != n) {
                throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_NUMBER_OF_ELEMENTS, this.nbSensorNoiseCovariance, n);
            }
        }
    }

    public int getSensorNumber() {
        return this.sensorNumber;
    }

    public void setSensorNumber(int sensorNumber) {
        this.sensorNumber = sensorNumber;
    }

    public String getSensorUsed() {
        return this.sensorUsed;
    }

    public void setSensorUsed(String sensorUsed) {
        this.sensorUsed = sensorUsed;
    }

    public int getNbSensorNoiseCovariance() {
        return this.nbSensorNoiseCovariance;
    }

    public void setNbSensorNoiseCovariance(int n) {
        this.nbSensorNoiseCovariance = n;
    }

    public double[] getSensorNoiseCovariance() {
        return this.sensorNoiseCovariance == null ? null : (double[])this.sensorNoiseCovariance.clone();
    }

    public void setSensorNoiseCovariance(double[] stddev) {
        if (stddev.length != this.nbSensorNoiseCovariance) {
            throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_NUMBER_OF_ELEMENTS, this.nbSensorNoiseCovariance, stddev.length);
        }
        this.sensorNoiseCovariance = (double[])stddev.clone();
    }

    public double getSensorFrequency() {
        return this.sensorFrequency;
    }

    public void setSensorFrequency(double frequency) {
        this.sensorFrequency = frequency;
    }
}

